/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ModConfig {
    public double hardCleanupThreshold = 0.6;
    public int mediumCleanupIntervalMinutes = 2;
    public int minimumCleanupIntervalMillis = 1000;
    public long hardCleanupMinIntervalMillis = 1000L;
    public double unusedClearMinutes = 5.0;
    public boolean enableMinimumCleanup = true;
    public boolean enableMediumCleanup = true;
    public boolean enableHardCleanup = true;
    public boolean logCleanupStats = false;
    public boolean autoStartMemoryThread = true;
    public boolean enableSecuritySandbox = true;
    public boolean cleanupOnWorldDisconnect = true;
    private static final File configFile = new File("config/shiro_config.json");

    public static ModConfig load() {
        ModConfig modConfig;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!configFile.exists()) {
            ModConfig defaultConfig = new ModConfig();
            try {
                configFile.getParentFile().mkdirs();
                try (FileWriter writer = new FileWriter(configFile);){
                    gson.toJson((Object)defaultConfig, (Appendable)writer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return defaultConfig;
        }
        FileReader reader = new FileReader(configFile);
        try {
            modConfig = (ModConfig)gson.fromJson((Reader)reader, ModConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new ModConfig();
            }
        }
        reader.close();
        return modConfig;
    }

    public void save() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(configFile);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

