/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.cpu;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BufferPool {
    private final Queue<ByteBuffer> pool = new ConcurrentLinkedQueue<ByteBuffer>();

    public ByteBuffer getBuffer(int size) {
        ByteBuffer buf = this.pool.poll();
        if (buf == null || buf.capacity() < size) {
            buf = ByteBuffer.allocateDirect(size);
        } else {
            buf.clear();
        }
        return buf;
    }

    public void returnBuffer(ByteBuffer buf) {
        this.pool.offer(buf);
    }

    public void warmUp(int count, int bufferSize) {
        for (int i = 0; i < count; ++i) {
            this.pool.offer(ByteBuffer.allocateDirect(bufferSize));
        }
    }
}

