/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.cpu;

import com.abdik.shiro.cpu.AdaptiveThreadPoolManager;
import com.abdik.shiro.cpu.AffinityManager;
import com.abdik.shiro.cpu.BufferPool;
import com.abdik.shiro.cpu.CPUCapDetector;
import com.abdik.shiro.cpu.CPUFeatureFlags;
import com.abdik.shiro.cpu.CPULoadAdaptiveCleaner;
import com.abdik.shiro.cpu.HotLoopDetector;
import com.abdik.shiro.cpu.IdleYieldReducer;
import com.abdik.shiro.cpu.JITPreWarmer;
import com.abdik.shiro.cpu.JVMOptionsTuner;
import com.abdik.shiro.cpu.SystemCpuMonitor;
import com.abdik.shiro.cpu.ThreadCpuTracker;
import com.abdik.shiro.cpu.ThreadPriorityTuner;
import com.abdik.shiro.cpu.ThreadSpinOptimizer;
import com.abdik.shiro.cpu.WorkerThreadManager;
import java.nio.ByteBuffer;
import net.fabricmc.api.ClientModInitializer;

public class CPUMod
implements ClientModInitializer {
    private WorkerThreadManager workerThreadManager;
    private ThreadCpuTracker threadCpuTracker;
    private BufferPool bufferPool;
    private AdaptiveThreadPoolManager adaptiveThreadPoolManager;

    public void onInitializeClient() {
        System.out.println("[CPUMod] Initializing CPU module...");
        AffinityManager.pinCurrentThreadToCpu(0);
        ThreadPriorityTuner.boostMainThread();
        JITPreWarmer.warmUp();
        IdleYieldReducer.reduceSpinning();
        ThreadSpinOptimizer.optimize();
        this.workerThreadManager = new WorkerThreadManager(2, Runtime.getRuntime().availableProcessors());
        this.threadCpuTracker = new ThreadCpuTracker();
        this.bufferPool = new BufferPool();
        this.bufferPool.warmUp(8, 4096);
        this.adaptiveThreadPoolManager = new AdaptiveThreadPoolManager(2, Runtime.getRuntime().availableProcessors());
        CPULoadAdaptiveCleaner.adaptiveCleanup(() -> {
            HotLoopDetector.logHotThreads();
            double load = CPULoadAdaptiveCleaner.getSystemCpuLoad();
            this.workerThreadManager.adjustThreadPool(load);
            long cpuTime = this.threadCpuTracker.getCurrentThreadCpuTime();
            if (cpuTime > 0L) {
                ByteBuffer tmp = this.bufferPool.getBuffer(1024);
                this.bufferPool.returnBuffer(tmp);
            }
            this.adaptiveThreadPoolManager.adjustThreadPool(load);
            SystemCpuMonitor.checkSystemCpu();
            JVMOptionsTuner.adjustJVMOptions();
        }, () -> {
            if (CPUCapDetector.isCPULimited()) {
                System.gc();
            }
        });
        boolean avxSupported = CPUFeatureFlags.supportsAVX();
        System.out.println("[CPUMod] AVX Supported: " + avxSupported);
        System.out.println("[CPUMod] CPU module initialized.");
    }
}

