/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro;

import com.abdik.shiro.ModConfig;
import com.abdik.shiro.commands.MemCommand;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.CommandDispatcher;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShiroMod
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"Shiro");
    public static volatile boolean running = true;
    public static ModConfig config;

    public void onInitializeClient() {
        LOGGER.info("[Shiro] Initializing Ultra Memory Cleanup mod.");
        config = ModConfig.load();
        LOGGER.info("[Shiro] Config loaded: Hard Cleanup Threshold = " + ShiroMod.config.hardCleanupThreshold * 100.0 + "%");
        LOGGER.info("[Shiro] Settings: min=" + ShiroMod.config.enableMinimumCleanup + ", med=" + ShiroMod.config.enableMediumCleanup + ", hard=" + ShiroMod.config.enableHardCleanup + ", autoThread=" + ShiroMod.config.autoStartMemoryThread + ", log=" + ShiroMod.config.logCleanupStats);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> MemCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher));
        if (ShiroMod.config.autoStartMemoryThread) {
            Thread memoryThread = new Thread(() -> {
                Runtime rt = Runtime.getRuntime();
                long lastMediumCleanup = System.currentTimeMillis();
                while (running) {
                    try {
                        long now = System.currentTimeMillis();
                        if (ShiroMod.config.enableMinimumCleanup) {
                            ShiroMod.minimumCleanup();
                        }
                        if (ShiroMod.config.enableMediumCleanup && now - lastMediumCleanup >= (long)ShiroMod.config.mediumCleanupIntervalMinutes * 60000L) {
                            if (ShiroMod.config.logCleanupStats) {
                                LOGGER.info("[Shiro] Medium cleanup triggered.");
                            }
                            ShiroMod.mediumCleanup();
                            lastMediumCleanup = now;
                        }
                        long used = rt.totalMemory() - rt.freeMemory();
                        long max = rt.maxMemory();
                        double usageRatio = (double)used / (double)max;
                        if (ShiroMod.config.enableHardCleanup && usageRatio > ShiroMod.config.hardCleanupThreshold) {
                            if (ShiroMod.config.logCleanupStats) {
                                LOGGER.info("[Shiro] Hard cleanup triggered by memory threshold (" + usageRatio * 100.0 + "%).");
                            }
                            ShiroMod.hardCleanup();
                            Thread.sleep(20000L);
                            continue;
                        }
                        Thread.sleep(ShiroMod.config.minimumCleanupIntervalMillis);
                    }
                    catch (InterruptedException e) {
                        LOGGER.warn("[Shiro] Memory monitoring thread interrupted.");
                        Thread.currentThread().interrupt();
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.warn("[Shiro] Exception in memory monitoring thread.", (Throwable)e);
                    }
                }
            }, "Shiro-MemoryMonitor");
            memoryThread.setDaemon(true);
            memoryThread.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                running = false;
            }));
        } else {
            LOGGER.info("[Shiro] Memory monitoring thread is disabled via config.");
        }
    }

    public static void minimumCleanup() {
        try {
            class_310 mc = class_310.method_1551();
            if (mc.field_1713 != null) {
                for (Field field : mc.field_1713.getClass().getDeclaredFields()) {
                    if (!List.class.isAssignableFrom(field.getType())) continue;
                    field.setAccessible(true);
                    Object list = field.get(mc.field_1713);
                    ShiroMod.safeClear(list, field.getName());
                }
            }
            mc.method_1531().method_4622();
        }
        catch (Exception e) {
            LOGGER.warn("[Shiro] Error in minimum cleanup.", (Throwable)e);
        }
    }

    public static void mediumCleanup() {
        System.gc();
        if (ShiroMod.config.logCleanupStats) {
            LOGGER.info("[Shiro] Medium cleanup executed.");
        }
    }

    public static void hardCleanup() {
        long startTime = System.currentTimeMillis();
        if (ShiroMod.config.logCleanupStats) {
            LOGGER.info("[Shiro] Starting hard cleanup...");
        }
        try {
            Field textRendererField;
            class_310 mc;
            block25: {
                mc = class_310.method_1551();
                if (mc.method_1483() != null) {
                    mc.method_1483().method_4881();
                    if (ShiroMod.config.logCleanupStats) {
                        LOGGER.info("[Shiro] Stopped all sounds.");
                    }
                }
                if (mc.field_1713 != null) {
                    for (Field field : mc.field_1713.getClass().getDeclaredFields()) {
                        if (!List.class.isAssignableFrom(field.getType())) continue;
                        field.setAccessible(true);
                        Object list = field.get(mc.field_1713);
                        ShiroMod.safeClear(list, "particleManager." + field.getName());
                    }
                }
                mc.method_1531().method_4622();
                if (ShiroMod.config.logCleanupStats) {
                    LOGGER.info("[Shiro] TextureManager ticked.");
                }
                if (mc.field_1769 != null) {
                    Field chunkManagerField = null;
                    for (Field field : mc.field_1769.getClass().getDeclaredFields()) {
                        if (!field.getType().getSimpleName().equals("ChunkManager")) continue;
                        chunkManagerField = field;
                        break;
                    }
                    if (chunkManagerField != null) {
                        chunkManagerField.setAccessible(true);
                        Object chunkManager = chunkManagerField.get(mc.field_1769);
                        if (chunkManager != null) {
                            for (Field subField : chunkManager.getClass().getDeclaredFields()) {
                                if (!Map.class.isAssignableFrom(subField.getType())) continue;
                                subField.setAccessible(true);
                                Object map = subField.get(chunkManager);
                                ShiroMod.safeClear(map, "chunkManager." + subField.getName());
                                break;
                            }
                        }
                    }
                }
                textRendererField = null;
                try {
                    textRendererField = class_310.class.getDeclaredField("textRenderer");
                }
                catch (NoSuchFieldException e1) {
                    if (!ShiroMod.config.logCleanupStats) break block25;
                    LOGGER.info("[Shiro] textRenderer field not found, skipping glyph cache cleanup.");
                }
            }
            if (textRendererField != null) {
                textRendererField.setAccessible(true);
                Object textRenderer = textRendererField.get(mc);
                if (textRenderer != null) {
                    Field glyphCacheField = textRenderer.getClass().getDeclaredField("glyphCache");
                    glyphCacheField.setAccessible(true);
                    Object glyphCache = glyphCacheField.get(textRenderer);
                    ShiroMod.safeClear(glyphCache, "textRenderer.glyphCache");
                }
            }
            try {
                Field advancementHandlerField = class_310.class.getDeclaredField("advancementHandler");
                advancementHandlerField.setAccessible(true);
                Object advancementHandler = advancementHandlerField.get(mc);
                if (advancementHandler != null) {
                    Field advancementsField = advancementHandler.getClass().getDeclaredField("advancements");
                    advancementsField.setAccessible(true);
                    Object advancements = advancementsField.get(advancementHandler);
                    ShiroMod.safeClear(advancements, "advancementHandler.advancements");
                }
            }
            catch (IllegalAccessException | NoSuchFieldException advancementHandlerField) {
                // empty catch block
            }
            for (int i = 0; i < 3; ++i) {
                System.gc();
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (ShiroMod.config.logCleanupStats) {
                LOGGER.info("[Shiro] Forced multiple GC cycles.");
            }
        }
        catch (Exception e) {
            LOGGER.error("[Shiro] Error during hard cleanup.", (Throwable)e);
        }
        if (ShiroMod.config.logCleanupStats) {
            long totalTime = System.currentTimeMillis() - startTime;
            LOGGER.info("[Shiro] Hard cleanup complete in " + totalTime + " ms.");
        }
    }

    private static void safeClear(Object collection, String name) {
        try {
            if (collection instanceof ImmutableCollection || collection instanceof ImmutableMap) {
                if (ShiroMod.config.logCleanupStats) {
                    LOGGER.info("[Shiro] Skipped clearing immutable: " + name);
                }
                return;
            }
            if (collection instanceof Collection) {
                ((Collection)collection).clear();
                if (ShiroMod.config.logCleanupStats) {
                    LOGGER.info("[Shiro] Cleared collection: " + name);
                }
            } else if (collection instanceof Map) {
                ((Map)collection).clear();
                if (ShiroMod.config.logCleanupStats) {
                    LOGGER.info("[Shiro] Cleared map: " + name);
                }
            }
        }
        catch (UnsupportedOperationException e) {
            LOGGER.warn("[Shiro] Cannot clear immutable collection: " + name);
        }
        catch (Exception e) {
            LOGGER.warn("[Shiro] Failed to clear field: " + name, (Throwable)e);
        }
    }
}

