/*
 * Decompiled with CFR 0.152.
 */
package com.singlemace;

import com.singlemace.Main;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.ItemStack;

public class MaceLimiter
implements Listener,
TabExecutor {
    private final Main plugin;
    private FileConfiguration config;
    private FileConfiguration storageConfig;
    private File storageFile;
    private final Map<UUID, Long> lastMessageTime = new HashMap<UUID, Long>();
    private static final long MESSAGE_COOLDOWN = 5000L;

    public MaceLimiter(Main plugin, FileConfiguration config) {
        this.plugin = plugin;
        this.config = config;
        this.setupStorage();
    }

    private void setupStorage() {
        this.storageFile = new File(this.plugin.getDataFolder(), "mace_storage.yml");
        if (!this.storageFile.exists()) {
            this.storageFile.getParentFile().mkdirs();
            try {
                this.storageFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.storageConfig = YamlConfiguration.loadConfiguration((File)this.storageFile);
        if (!this.storageConfig.contains("total-maces")) {
            this.storageConfig.set("total-maces", (Object)0);
            this.saveStorage();
        }
    }

    private void saveStorage() {
        try {
            this.storageConfig.save(this.storageFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int getConfigInt(String key, int def) {
        ConfigurationSection section;
        if (this.config.isConfigurationSection("configs") && (section = this.config.getConfigurationSection("configs")) != null && section.contains(key)) {
            return section.getInt(key, def);
        }
        return this.config.getInt(key, def);
    }

    private boolean getConfigBoolean(String key, boolean def) {
        ConfigurationSection section;
        if (this.config.isConfigurationSection("configs") && (section = this.config.getConfigurationSection("configs")) != null && section.contains(key)) {
            return section.getBoolean(key, def);
        }
        return this.config.getBoolean(key, def);
    }

    private boolean isMace(ItemStack item) {
        return item != null && item.getType() == Material.MACE;
    }

    private int getMaxEnchantmentLevel(Enchantment enchantment) {
        String enchantmentName = enchantment.getKey().getKey().toUpperCase();
        return this.config.getInt("enchantment_limits." + enchantmentName, enchantment.getMaxLevel());
    }

    private void downgradeEnchantments(Player player, ItemStack item) {
        if (item == null) {
            return;
        }
        Map enchantments = item.getEnchantments();
        for (Map.Entry entry : enchantments.entrySet()) {
            int maxLevel;
            Enchantment enchantment = (Enchantment)entry.getKey();
            int level = (Integer)entry.getValue();
            if (level <= (maxLevel = this.getMaxEnchantmentLevel(enchantment))) continue;
            item.removeEnchantment(enchantment);
            item.addUnsafeEnchantment(enchantment, maxLevel);
            this.sendMessageWithCooldown(player, String.valueOf(ChatColor.RED) + "The enchantment level for " + enchantment.getKey().getKey() + " on your item has been downgraded to " + maxLevel + ".");
        }
    }

    private void sendMessageWithCooldown(Player player, String message) {
        UUID playerUUID = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (!this.lastMessageTime.containsKey(playerUUID) || currentTime - this.lastMessageTime.get(playerUUID) > 5000L) {
            player.sendMessage(message);
            this.lastMessageTime.put(playerUUID, currentTime);
        }
    }

    @EventHandler
    public void onPrepareItemCraft(PrepareItemCraftEvent event) {
        if (!this.getConfigBoolean("enabled", true)) {
            return;
        }
        ItemStack result = event.getRecipe().getResult();
        if (!this.isMace(result)) {
            return;
        }
        int maxMaces = this.getConfigInt("max-maces-overall", 1);
        int totalMaces = this.storageConfig.getInt("total-maces", 0);
        if (totalMaces >= maxMaces) {
            event.getInventory().setResult(null);
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        if (!this.getConfigBoolean("enabled", true)) {
            return;
        }
        ItemStack item = event.getRecipe().getResult();
        if (!this.isMace(item)) {
            return;
        }
        int maxMaces = this.getConfigInt("max-maces-overall", 1);
        int totalMaces = this.storageConfig.getInt("total-maces", 0);
        if (totalMaces >= maxMaces) {
            HumanEntity humanEntity = event.getWhoClicked();
            if (humanEntity instanceof Player) {
                Player player = (Player)humanEntity;
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 0.0f);
            }
            event.setCancelled(true);
            return;
        }
        this.storageConfig.set("total-maces", (Object)(totalMaces + 1));
        this.saveStorage();
    }

    @EventHandler
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        if (!this.getConfigBoolean("enabled", true)) {
            return;
        }
        ItemStack result = event.getResult();
        if (!this.isMace(result)) {
            return;
        }
        int maxMaces = this.getConfigInt("max-maces-overall", 1);
        int totalMaces = this.storageConfig.getInt("total-maces", 0);
        if (totalMaces >= maxMaces) {
            event.setResult(null);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack currentItem = event.getCurrentItem();
        ItemStack cursorItem = event.getCursor();
        if (currentItem != null) {
            this.downgradeEnchantments(player, currentItem);
        }
        if (cursorItem != null) {
            this.downgradeEnchantments(player, cursorItem);
        }
    }

    @EventHandler
    public void onCrafter(CrafterCraftEvent event) {
        event.setCancelled(true);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("macelimiter")) {
            return false;
        }
        if (!sender.isOp()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You must be OP to use this command.");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7eMaceLimiter commands: toggle, reload, reset");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "toggle": {
                boolean enabled = this.config.getBoolean("enabled", true);
                this.config.set("enabled", (Object)(!enabled ? 1 : 0));
                this.plugin.saveConfig();
                sender.sendMessage("\u00a7aMaceLimiter is now " + (!enabled ? "enabled" : "disabled") + ".");
                break;
            }
            case "reload": {
                this.plugin.reloadConfig();
                this.config = this.plugin.getConfig();
                this.setupStorage();
                sender.sendMessage("\u00a7aMaceLimiter plugin fully reloaded.");
                break;
            }
            case "reset": {
                if (this.config.isConfigurationSection("configs")) {
                    ConfigurationSection section = this.config.getConfigurationSection("configs");
                    section.set("enabled", (Object)true);
                    section.set("max-maces-overall", (Object)1);
                } else {
                    this.config.set("enabled", (Object)true);
                    this.config.set("max-maces-overall", (Object)1);
                }
                this.config.set("enchantment_limits.DENSITY", (Object)5);
                this.config.set("enchantment_limits.BREACH", (Object)4);
                this.config.set("enchantment_limits.WIND_BURST", (Object)3);
                this.plugin.saveConfig();
                this.storageConfig.set("total-maces", (Object)0);
                this.saveStorage();
                sender.sendMessage("\u00a7aMaceLimiter config and mace count reset. Example values applied.");
                break;
            }
            default: {
                sender.sendMessage("\u00a7cUnknown subcommand. Use: toggle, reload, reset");
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!command.getName().equalsIgnoreCase("macelimiter")) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> sub = Arrays.asList("toggle", "reload", "reset");
            for (String s : sub) {
                if (!s.startsWith(args[0].toLowerCase())) continue;
                completions.add(s);
            }
        }
        return completions;
    }

    public int getTotalMaces() {
        return this.storageConfig.getInt("total-maces", 0);
    }
}

