/*
 * Decompiled with CFR 0.152.
 */
package com.singlemace;

import com.singlemace.MaceLimiter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Main
extends JavaPlugin {
    private MaceLimiter maceLimiter;
    private NamespacedKey maceRecipeKey;

    public void onEnable() {
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        this.maceLimiter = new MaceLimiter(this, config);
        this.getServer().getPluginManager().registerEvents((Listener)this.maceLimiter, (Plugin)this);
        this.getCommand("macelimiter").setExecutor((CommandExecutor)this.maceLimiter);
        this.getCommand("macelimiter").setTabCompleter((TabCompleter)this.maceLimiter);
        this.maceRecipeKey = new NamespacedKey((Plugin)this, "mace");
        this.checkForUpdate();
        this.getLogger().info("MaceLimiter plugin enabled.");
    }

    public void onDisable() {
        Bukkit.removeRecipe((NamespacedKey)this.maceRecipeKey);
        this.getLogger().info("MaceLimiter plugin disabled.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return this.maceLimiter.onCommand(sender, command, label, args);
    }

    private void checkForUpdate() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                String currentVersion = this.getDescription().getVersion();
                URL url = new URL("https://api.modrinth.com/v2/project/macelimiter/version");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("User-Agent", "MaceLimiter/" + currentVersion);
                connection.connect();
                if (connection.getResponseCode() != 200) {
                    this.getLogger().warning("Could not check for updates: HTTP " + connection.getResponseCode());
                    return;
                }
                JSONParser parser = new JSONParser();
                JSONArray versions = (JSONArray)parser.parse((Reader)new InputStreamReader(connection.getInputStream()));
                if (versions.isEmpty()) {
                    return;
                }
                JSONObject latest = (JSONObject)versions.get(0);
                String latestVersion = (String)latest.get((Object)"version_number");
                if (!latestVersion.equalsIgnoreCase(currentVersion)) {
                    String updateMessage = String.valueOf(ChatColor.GOLD) + "[MaceLimiter] A new version (" + latestVersion + ") is available! " + String.valueOf(ChatColor.GRAY) + "You are on " + currentVersion + ". " + String.valueOf(ChatColor.AQUA) + "https://modrinth.com/plugin/macelimiter";
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.isOp()) continue;
                        player.sendMessage(updateMessage);
                    }
                    this.getLogger().info(ChatColor.stripColor((String)updateMessage));
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Failed to check for MaceLimiter updates", e);
            }
        });
    }

    public int getTotalMaces() {
        return this.maceLimiter.getTotalMaces();
    }
}

