/*
 * Decompiled with CFR 0.152.
 */
package com.duckiee2;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MaceEquip
implements Listener {
    private final JavaPlugin plugin;

    public MaceEquip(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    private boolean isMace(ItemStack item) {
        return item != null && item.getType() == Material.MACE;
    }

    @EventHandler
    public void onPickup(PlayerPickupItemEvent event) {
        ItemStack item = event.getItem().getItemStack();
        if (this.isMace(item)) {
            this.playDarkRedDustEffect(event.getPlayer(), true);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        final Item droppedItem = event.getItemDrop();
        ItemStack itemStack = droppedItem.getItemStack();
        if (this.isMace(itemStack)) {
            this.playDarkRedDustEffect(event.getPlayer(), false);
            new BukkitRunnable(this){
                final /* synthetic */ MaceEquip this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    droppedItem.setGlowing(true);
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }

    private void playDarkRedDustEffect(Player player, final boolean bottomToTop) {
        final Location base = player.getLocation().add(0.0, 0.1, 0.0);
        final World world = player.getWorld();
        final Particle.DustOptions dust = new Particle.DustOptions(Color.fromRGB((int)147, (int)112, (int)219), 1.5f);
        final int points = 16;
        final double radius = 0.6;
        new BukkitRunnable(this){
            double y = 0.0;
            final /* synthetic */ MaceEquip this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.y > 2.0) {
                    this.cancel();
                    return;
                }
                double ringY = bottomToTop ? this.y : 2.0 - this.y;
                for (int i = 0; i < points; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)points;
                    double x = Math.cos(angle) * radius;
                    double z = Math.sin(angle) * radius;
                    world.spawnParticle(Particle.DUST, base.clone().add(x, ringY, z), 0, 0.0, 0.0, 0.0, 1.0, (Object)dust);
                }
                this.y += 0.15;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        world.playSound(base, Sound.ENTITY_TURTLE_EGG_BREAK, 1.3f, 1.2f);
    }
}

