/*
 * Decompiled with CFR 0.152.
 */
package com.singlemace;

import com.singlemace.Main;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MaceLimiter
implements Listener,
TabExecutor {
    private final Main plugin;
    private FileConfiguration config;
    private FileConfiguration storageConfig;
    private File storageFile;
    private final Map<UUID, Long> lastMessageTime = new HashMap<UUID, Long>();
    private static final long MESSAGE_COOLDOWN = 5000L;
    private BossBar activeBossBar = null;
    private boolean ritualInProgress = false;

    public MaceLimiter(Main plugin, FileConfiguration config) {
        this.plugin = plugin;
        this.config = config;
        this.setupStorage();
    }

    private void setupStorage() {
        this.storageFile = new File(this.plugin.getDataFolder(), "mace_storage.yml");
        if (!this.storageFile.exists()) {
            this.storageFile.getParentFile().mkdirs();
            try {
                this.storageFile.createNewFile();
            }
            catch (IOException var2) {
                var2.printStackTrace();
            }
        }
        this.storageConfig = YamlConfiguration.loadConfiguration((File)this.storageFile);
        if (!this.storageConfig.contains("total-maces")) {
            this.storageConfig.set("total-maces", (Object)0);
            this.saveStorage();
        }
        if (!this.storageConfig.contains("ritual-completed")) {
            this.storageConfig.set("ritual-completed", (Object)false);
            this.saveStorage();
        }
    }

    private void saveStorage() {
        try {
            this.storageConfig.save(this.storageFile);
        }
        catch (IOException var2) {
            var2.printStackTrace();
        }
    }

    private int getConfigInt(String key, int def) {
        ConfigurationSection section;
        if (this.config.isConfigurationSection("configs") && (section = this.config.getConfigurationSection("configs")) != null && section.contains(key)) {
            return section.getInt(key, def);
        }
        return this.config.getInt(key, def);
    }

    private boolean getConfigBoolean(String key, boolean def) {
        ConfigurationSection section;
        if (this.config.isConfigurationSection("configs") && (section = this.config.getConfigurationSection("configs")) != null && section.contains(key)) {
            return section.getBoolean(key, def);
        }
        return this.config.getBoolean(key, def);
    }

    private boolean isMace(ItemStack item) {
        return item != null && item.getType() == Material.MACE;
    }

    private boolean isRitualCompleted() {
        return this.storageConfig.getBoolean("ritual-completed", false);
    }

    private void setRitualCompleted() {
        this.storageConfig.set("ritual-completed", (Object)true);
        this.saveStorage();
    }

    private int getMaxEnchantmentLevel(Enchantment enchantment) {
        String enchantmentName = enchantment.getKey().getKey().toUpperCase();
        return this.config.getInt("enchantment_limits." + enchantmentName, enchantment.getMaxLevel());
    }

    private void downgradeEnchantments(Player player, ItemStack item) {
        if (item != null) {
            Map enchantments = item.getEnchantments();
            for (Map.Entry entry : enchantments.entrySet()) {
                int maxLevel;
                Enchantment enchantment = (Enchantment)entry.getKey();
                int level = (Integer)entry.getValue();
                if (level <= (maxLevel = this.getMaxEnchantmentLevel(enchantment))) continue;
                item.removeEnchantment(enchantment);
                item.addUnsafeEnchantment(enchantment, maxLevel);
                String var10002 = String.valueOf(ChatColor.RED);
                this.sendMessageWithCooldown(player, var10002 + "The enchantment level for " + enchantment.getKey().getKey() + " on your item has been downgraded to " + maxLevel + ".");
            }
        }
    }

    private void sendMessageWithCooldown(Player player, String message) {
        UUID playerUUID = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (!this.lastMessageTime.containsKey(playerUUID) || currentTime - this.lastMessageTime.get(playerUUID) > 5000L) {
            player.sendMessage(message);
            this.lastMessageTime.put(playerUUID, currentTime);
        }
    }

    private void startRitual(Player player, final Location playerLocation) {
        String dimensionMessage;
        BossBar bossBar;
        this.ritualInProgress = true;
        ChatColor Color2 = ChatColor.LIGHT_PURPLE;
        String formattedItemName = String.valueOf(Color2) + "The Mace - Crafting Ritual";
        this.activeBossBar = bossBar = Bukkit.createBossBar((String)formattedItemName, (BarColor)BarColor.PINK, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        for (Player p : Bukkit.getOnlinePlayers()) {
            bossBar.addPlayer(p);
        }
        String worldName = playerLocation.getWorld().getName();
        if (worldName.equalsIgnoreCase("world")) {
            dimensionMessage = String.valueOf(ChatColor.GREEN) + "Overworld";
        } else if (worldName.equalsIgnoreCase("world_end") || worldName.equalsIgnoreCase("world_the_end")) {
            dimensionMessage = String.valueOf(ChatColor.DARK_PURPLE) + "End";
        } else if (worldName.equalsIgnoreCase("world_nether") || worldName.equalsIgnoreCase("world_the_nether")) {
            dimensionMessage = String.valueOf(ChatColor.DARK_RED) + "Nether";
        } else {
            String var10000 = String.valueOf(ChatColor.GRAY);
            dimensionMessage = var10000 + worldName;
        }
        final String x = String.valueOf(playerLocation.getBlockX());
        final String y = String.valueOf(playerLocation.getBlockY());
        final String z = String.valueOf(playerLocation.getBlockZ());
        String formattedMessage = String.valueOf(ChatColor.GOLD) + player.getName() + " " + String.valueOf(ChatColor.LIGHT_PURPLE) + "has started crafting the mace at " + String.valueOf(ChatColor.GOLD) + x + " " + y + " " + z + " " + dimensionMessage;
        Bukkit.broadcastMessage((String)formattedMessage);
        playerLocation.getWorld().playSound(playerLocation, Sound.BLOCK_END_PORTAL_SPAWN, 1.0f, 0.0f);
        int totalMaces = this.storageConfig.getInt("total-maces", 0);
        this.storageConfig.set("total-maces", (Object)(totalMaces + 1));
        this.saveStorage();
        final int ritualDuration = this.getConfigInt("ritual-duration", 900);
        final int[] timeRemaining = new int[]{ritualDuration};
        bossBar.setProgress(0.0);
        new BukkitRunnable(this){
            final /* synthetic */ MaceLimiter this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                timeRemaining[0] = timeRemaining[0] - 1;
                double progress = 1.0 - (double)timeRemaining[0] / (double)ritualDuration;
                bossBar.setProgress(Math.min(1.0, progress));
                bossBar.setTitle(String.valueOf(ChatColor.LIGHT_PURPLE) + "The Mace " + String.valueOf(ChatColor.GOLD) + x + " " + y + " " + z + " " + dimensionMessage);
                double currentRadius = 10.0 * (1.0 - progress);
                for (int i = 0; i < 108; ++i) {
                    double angle = Math.PI * 2 * (double)i / 108.0;
                    double particleX = playerLocation.getX() + currentRadius * Math.cos(angle);
                    double particleZ = playerLocation.getZ() + currentRadius * Math.sin(angle);
                    double particleY = playerLocation.getY() + 0.2;
                    Particle.DustOptions orangeDust = new Particle.DustOptions(Color.fromRGB((int)255, (int)165, (int)0), 2.0f);
                    Location particleLocation = new Location(playerLocation.getWorld(), particleX, particleY, particleZ);
                    playerLocation.getWorld().spawnParticle(Particle.DUST, particleLocation, 5, (Object)orangeDust);
                }
                if (timeRemaining[0] <= 0) {
                    Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.LIGHT_PURPLE) + "The Mace has been successfully crafted!"));
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        p.playSound(p.getLocation(), Sound.ENTITY_WITHER_DEATH, 1.0f, 2.0f);
                    }
                    Location dropLocation = playerLocation.clone();
                    dropLocation.getWorld().dropItemNaturally(dropLocation, new ItemStack(Material.MACE));
                    this.this$0.setRitualCompleted();
                    bossBar.removeAll();
                    this.this$0.activeBossBar = null;
                    this.this$0.ritualInProgress = false;
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.activeBossBar != null) {
            this.activeBossBar.addPlayer(event.getPlayer());
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        ItemStack item;
        if (this.getConfigBoolean("enabled", true) && this.isMace(item = event.getRecipe().getResult())) {
            int maxMaces = this.getConfigInt("max-maces-overall", 1);
            int totalMaces = this.storageConfig.getInt("total-maces", 0);
            if (totalMaces >= maxMaces) {
                HumanEntity var6 = event.getWhoClicked();
                if (var6 instanceof Player) {
                    Player player = (Player)var6;
                    player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 0.0f);
                }
                event.setCancelled(true);
            } else {
                event.setCancelled(true);
                Player player = (Player)event.getWhoClicked();
                if (this.isRitualCompleted() || !this.getConfigBoolean("ritual-enabled", true)) {
                    player.getWorld().dropItemNaturally(player.getLocation(), new ItemStack(Material.MACE));
                    this.storageConfig.set("total-maces", (Object)(totalMaces + 1));
                    this.saveStorage();
                } else {
                    if (this.ritualInProgress) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "A mace crafting ritual is already in progress!");
                        return;
                    }
                    player.closeInventory();
                    player.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.HEAVY_CORE, 1)});
                    player.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.BREEZE_ROD, 1)});
                    this.startRitual(player, player.getLocation());
                }
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity var3 = event.getWhoClicked();
        if (var3 instanceof Player) {
            Player player = (Player)var3;
            ItemStack currentItem = event.getCurrentItem();
            ItemStack cursorItem = event.getCursor();
            if (currentItem != null) {
                this.downgradeEnchantments(player, currentItem);
            }
            if (cursorItem != null) {
                this.downgradeEnchantments(player, cursorItem);
            }
        }
    }

    @EventHandler
    public void onCrafter(CrafterCraftEvent event) {
        ItemStack result = event.getResult();
        if (result != null && result.getType() == Material.MACE) {
            event.setCancelled(true);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("macelimiter")) {
            return false;
        }
        if (!sender.isOp()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You must be OP to use this command.");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7eMaceLimiter commands: toggle, reload, reset, status");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "toggle": {
                boolean enabled = this.config.getBoolean("enabled", true);
                this.config.set("enabled", (Object)(!enabled ? 1 : 0));
                this.plugin.saveConfig();
                sender.sendMessage("\u00a7aMaceLimiter is now " + (!enabled ? "enabled" : "disabled") + ".");
                break;
            }
            case "reload": {
                this.plugin.reloadConfig();
                this.config = this.plugin.getConfig();
                this.setupStorage();
                sender.sendMessage("\u00a7aMaceLimiter has been reloaded.");
                break;
            }
            case "reset": {
                if (this.config.isConfigurationSection("configs")) {
                    ConfigurationSection section = this.config.getConfigurationSection("configs");
                    section.set("enabled", (Object)true);
                    section.set("max-maces-overall", (Object)1);
                } else {
                    this.config.set("enabled", (Object)true);
                    this.config.set("max-maces-overall", (Object)1);
                }
                this.config.set("enchantment_limits.DENSITY", (Object)5);
                this.config.set("enchantment_limits.BREACH", (Object)4);
                this.config.set("enchantment_limits.WIND_BURST", (Object)3);
                this.config.set("ritual-enabled", (Object)true);
                this.plugin.saveConfig();
                this.storageConfig.set("total-maces", (Object)0);
                this.storageConfig.set("ritual-completed", (Object)false);
                this.saveStorage();
                this.ritualInProgress = false;
                if (this.activeBossBar != null) {
                    this.activeBossBar.removeAll();
                    this.activeBossBar = null;
                }
                sender.sendMessage("\u00a7aMaceLimiter config, mace count, and ritual status reset.");
                break;
            }
            case "status": {
                boolean ritualCompleted = this.isRitualCompleted();
                int totalMaces = this.getTotalMaces();
                sender.sendMessage("\u00a76=== MaceLimiter Status ===");
                sender.sendMessage("\u00a7eRitual Completed: " + (ritualCompleted ? "\u00a7aYes" : "\u00a7cNo"));
                sender.sendMessage("\u00a7eRitual In Progress: " + (this.ritualInProgress ? "\u00a7aYes" : "\u00a7cNo"));
                sender.sendMessage("\u00a7eRitual Enabled: " + (this.getConfigBoolean("ritual-enabled", true) ? "\u00a7aYes" : "\u00a7cNo"));
                sender.sendMessage("\u00a7eTotal Maces Crafted: \u00a7f" + totalMaces);
                sender.sendMessage("\u00a7ePlugin Enabled: " + (this.getConfigBoolean("enabled", true) ? "\u00a7aYes" : "\u00a7cNo"));
                break;
            }
            default: {
                sender.sendMessage("\u00a7cUnknown subcommand. Use: toggle, reload, reset, status");
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!command.getName().equalsIgnoreCase("macelimiter")) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> sub = Arrays.asList("toggle", "reload", "reset", "status");
            for (String s : sub) {
                if (!s.startsWith(args[0].toLowerCase())) continue;
                completions.add(s);
            }
        }
        return completions;
    }

    public int getTotalMaces() {
        return this.storageConfig.getInt("total-maces", 0);
    }

    public boolean getRitualStatus() {
        return this.isRitualCompleted();
    }
}

