/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.loot;

import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VanillaChestLootData {
    private static final String LOG_PREFIX = "[Loot Table Injection]";
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Map<ResourceLocation, ResourceLocation> LOOT_TABLE_INJECTIONS = Map.ofEntries(Map.entry(new ResourceLocation("minecraft", "chests/abandoned_mineshaft"), new ResourceLocation("scrap_tech_workshop", "inject/chests/abandoned_mineshaft")), Map.entry(new ResourceLocation("minecraft", "chests/simple_dungeon"), new ResourceLocation("scrap_tech_workshop", "inject/chests/simple_dungeon")), Map.entry(new ResourceLocation("minecraft", "chests/stronghold_corridor"), new ResourceLocation("scrap_tech_workshop", "inject/chests/stronghold_corridor")), Map.entry(new ResourceLocation("minecraft", "chests/ancient_city"), new ResourceLocation("scrap_tech_workshop", "inject/chests/ancient_city")), Map.entry(new ResourceLocation("minecraft", "chests/end_city_treasure"), new ResourceLocation("scrap_tech_workshop", "inject/chests/end_city_treasure")), Map.entry(new ResourceLocation("minecraft", "chests/ruined_portal"), new ResourceLocation("scrap_tech_workshop", "inject/chests/ruined_portal")), Map.entry(new ResourceLocation("minecraft", "chests/bastion_treasure"), new ResourceLocation("scrap_tech_workshop", "inject/chests/bastion_treasure")), Map.entry(new ResourceLocation("minecraft", "chests/shipwreck_supply"), new ResourceLocation("scrap_tech_workshop", "inject/chests/shipwreck_supply")), Map.entry(new ResourceLocation("minecraft", "chests/ocean_ruin_cold"), new ResourceLocation("scrap_tech_workshop", "inject/chests/ocean_ruin_cold")), Map.entry(new ResourceLocation("minecraft", "chests/ocean_ruin_warm"), new ResourceLocation("scrap_tech_workshop", "inject/chests/ocean_ruin_warm")), Map.entry(new ResourceLocation("minecraft", "chests/desert_pyramid"), new ResourceLocation("scrap_tech_workshop", "inject/chests/desert_pyramid")));

    private VanillaChestLootData() {
    }

    public static ResourceLocation getInjectionTable(ResourceLocation targetTable) {
        return LOOT_TABLE_INJECTIONS.get(targetTable);
    }

    public static boolean shouldModifyLootTable(ResourceLocation targetTable) {
        return targetTable != null && LOOT_TABLE_INJECTIONS.containsKey(targetTable);
    }

    public static Map<ResourceLocation, ResourceLocation> getAllInjections() {
        return LOOT_TABLE_INJECTIONS;
    }

    public static void logSuccessfulInjection(ResourceLocation targetTable, ResourceLocation injectionTable) {
        log.debug("{} Successfully injected '{}' into '{}'", (Object)LOG_PREFIX, (Object)injectionTable, (Object)targetTable);
    }

    public static void logFailedInjection(ResourceLocation targetTable, ResourceLocation injectionTable, String reason) {
        log.warn("{} Failed to inject '{}' into '{}': {}", (Object)LOG_PREFIX, (Object)injectionTable, (Object)targetTable, (Object)reason);
    }

    public static void logSkippedInjection(ResourceLocation targetTable, String reason) {
        log.debug("{} Skipped '{}': {}", (Object)LOG_PREFIX, (Object)targetTable, (Object)reason);
    }
}

