/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.rechargestation;

import de.markusbordihn.scraptechworkshop.block.entity.AbstractWorkshopBlockEntity;
import de.markusbordihn.scraptechworkshop.block.entity.rechargestation.RechargeStationContainer;
import de.markusbordihn.scraptechworkshop.block.rechargestation.RechargeStationBlock;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyPowerData;
import de.markusbordihn.scraptechworkshop.data.rechargestation.RechargeStationStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyCell;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerConsumer;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.item.component.EmptyEnergyCellBlockItem;
import de.markusbordihn.scraptechworkshop.item.component.EmptyEnergyCellItem;
import de.markusbordihn.scraptechworkshop.menu.RechargeStationMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RechargeStationBlockEntity
extends AbstractWorkshopBlockEntity
implements EnergyPowerConsumer {
    public static final String ID = "recharge_station";
    public static final String PROGRESS_TAG = "Progress";
    public static final String MAX_PROGRESS_TAG = "MaxProgress";
    public static final String STATUS_DELAY_TIMER_TAG = "StatusDelayTimer";
    private static final int ENERGY_CAPACITY_MAH = 10000;
    private static final int ENERGY_CONSUMPTION_PER_TICK = 5;
    private static final int RECHARGE_RATE = 5;
    private static final int STATUS_CHANGE_DELAY = 20;
    private static final int PROGRESS_DATA_INDEX = 0;
    private static final int MAX_PROGRESS_DATA_INDEX = 1;
    private static final String TRANSLATION_KEY = "container.scrap_tech_workshop.recharge_station";
    private static final int ENERGY_FLOW_DISPLAY_TICKS = 40;
    public static BlockEntityType<RechargeStationBlockEntity> TYPE;
    private final RechargeStationContainer container;
    private final ContainerData energyContainerData = this.createEnergyContainerData();
    private int progress = 0;
    private int maxProgress = 100;
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> RechargeStationBlockEntity.this.progress;
                case 1 -> RechargeStationBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    RechargeStationBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    RechargeStationBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private EnergyPowerData energyData = EnergyPowerData.empty();
    private long lastEnergyReceiveTick = 0L;
    private long lastEnergyDistributeTick = 0L;
    private int tickCounter = 0;
    private int statusDelayTimer = 0;
    private RechargeStationStatus pendingStatus = null;

    public RechargeStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(TYPE, blockPos, blockState);
        this.container = new RechargeStationContainer(2, this::m_6596_);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, RechargeStationBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        ++blockEntity.tickCounter;
        long currentTick = level.m_46467_();
        if (blockEntity.lastEnergyReceiveTick > 0L && currentTick - blockEntity.lastEnergyReceiveTick > 40L) {
            blockEntity.energyContainerData.m_8050_(4, 0);
            blockEntity.lastEnergyReceiveTick = 0L;
        }
        if (blockEntity.lastEnergyDistributeTick > 0L && currentTick - blockEntity.lastEnergyDistributeTick > 40L) {
            blockEntity.energyContainerData.m_8050_(5, 0);
            blockEntity.lastEnergyDistributeTick = 0L;
        }
        blockEntity.updateEnergyFlow(currentTick);
        boolean hasEnoughEnergy = blockEntity.hasStableEnergy(5);
        ItemStack inputItem = blockEntity.container.m_8020_(0);
        RechargeStationStatus newStatus = RechargeStationBlockEntity.determineStatus(hasEnoughEnergy, inputItem);
        RechargeStationBlockEntity.updateBlockStatus(level, blockPos, blockState, blockEntity, newStatus);
        RechargeStationBlockEntity.processCharging(level, blockPos, blockState, blockEntity, newStatus, hasEnoughEnergy, inputItem);
        RechargeStationBlockEntity.resetProgressIfNeeded(blockEntity, newStatus);
    }

    private static void updateBlockStatus(Level level, BlockPos blockPos, BlockState blockState, RechargeStationBlockEntity blockEntity, RechargeStationStatus newStatus) {
        RechargeStationStatus currentStatus = (RechargeStationStatus)((Object)blockState.m_61143_(RechargeStationBlock.STATUS));
        if (newStatus == currentStatus) {
            blockEntity.statusDelayTimer = 0;
            blockEntity.pendingStatus = null;
            return;
        }
        if (blockEntity.pendingStatus != newStatus) {
            blockEntity.pendingStatus = newStatus;
            blockEntity.statusDelayTimer = 0;
            return;
        }
        ++blockEntity.statusDelayTimer;
        if (blockEntity.statusDelayTimer >= 20) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_(RechargeStationBlock.STATUS, (Comparable)((Object)newStatus)), 3);
            blockEntity.progress = 0;
            blockEntity.statusDelayTimer = 0;
            blockEntity.pendingStatus = null;
        }
    }

    private static void processCharging(Level level, BlockPos blockPos, BlockState blockState, RechargeStationBlockEntity blockEntity, RechargeStationStatus status, boolean hasEnoughEnergy, ItemStack inputItem) {
        if (status != RechargeStationStatus.CHARGING || !hasEnoughEnergy) {
            return;
        }
        if (inputItem.m_41720_() instanceof EmptyEnergyCellBlockItem) {
            RechargeStationBlockEntity.chargeEmptyCell(level, blockPos, blockState, blockEntity, ModItems.ENERGY_CELL_BLOCK.get());
        } else if (inputItem.m_41720_() instanceof EmptyEnergyCellItem) {
            RechargeStationBlockEntity.chargeEmptyCell(level, blockPos, blockState, blockEntity, ModItems.ENERGY_CELL.get());
        } else {
            Item item = inputItem.m_41720_();
            if (item instanceof EnergyCell) {
                EnergyCell cell = (EnergyCell)item;
                RechargeStationBlockEntity.chargeEnergyCell(level, blockPos, blockState, blockEntity, inputItem, cell);
            }
        }
    }

    private static void chargeEmptyCell(Level level, BlockPos blockPos, BlockState blockState, RechargeStationBlockEntity blockEntity, Item cellItem) {
        ItemStack chargedCell = new ItemStack((ItemLike)cellItem);
        Item item = chargedCell.m_41720_();
        if (!(item instanceof EnergyCell)) {
            return;
        }
        EnergyCell energyCellItem = (EnergyCell)item;
        energyCellItem.setEnergy(chargedCell, 5);
        blockEntity.container.m_6836_(0, chargedCell);
        blockEntity.consumeEnergy(5);
        blockEntity.progress = 1;
        blockEntity.maxProgress = 100;
        blockEntity.m_6596_();
        RechargeStationBlockEntity.playChargingEffects(level, blockPos, blockState, blockEntity);
    }

    private static void chargeEnergyCell(Level level, BlockPos blockPos, BlockState blockState, RechargeStationBlockEntity blockEntity, ItemStack inputItem, EnergyCell cell) {
        if (cell.getEnergy(inputItem) >= cell.getCapacity()) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_(RechargeStationBlock.STATUS, (Comparable)((Object)RechargeStationStatus.DONE)), 3);
            return;
        }
        int energyToTransfer = Math.min(5, cell.getCapacity() - cell.getEnergy(inputItem));
        cell.setEnergy(inputItem, cell.getEnergy(inputItem) + energyToTransfer);
        blockEntity.consumeEnergy(5);
        blockEntity.progress = cell.getEnergy(inputItem) * 100 / cell.getCapacity();
        blockEntity.maxProgress = 100;
        blockEntity.m_6596_();
        RechargeStationBlockEntity.playChargingEffects(level, blockPos, blockState, blockEntity);
    }

    private static void playChargingEffects(Level level, BlockPos blockPos, BlockState blockState, RechargeStationBlockEntity blockEntity) {
        if (blockEntity.tickCounter % 10 == 0) {
            RechargeStationBlockEntity.spawnChargingParticles(level, blockPos, blockState);
        }
        if (blockEntity.tickCounter % 20 == 0) {
            RechargeStationBlockEntity.playChargingSound(level, blockPos);
        }
    }

    private static void resetProgressIfNeeded(RechargeStationBlockEntity blockEntity, RechargeStationStatus status) {
        if (status == RechargeStationStatus.DONE || status == RechargeStationStatus.IDLE) {
            blockEntity.progress = 0;
        }
    }

    private static RechargeStationStatus determineStatus(boolean hasEnoughEnergy, ItemStack inputItem) {
        if (!hasEnoughEnergy) {
            return RechargeStationStatus.NO_POWER;
        }
        if (inputItem.m_41619_()) {
            return RechargeStationStatus.IDLE;
        }
        if (inputItem.m_41720_() instanceof EmptyEnergyCellBlockItem) {
            return RechargeStationStatus.CHARGING;
        }
        if (inputItem.m_41720_() instanceof EmptyEnergyCellItem) {
            return RechargeStationStatus.CHARGING;
        }
        Item item = inputItem.m_41720_();
        if (item instanceof EnergyCell) {
            EnergyCell cell = (EnergyCell)item;
            return cell.getEnergy(inputItem) >= cell.getCapacity() ? RechargeStationStatus.DONE : RechargeStationStatus.CHARGING;
        }
        return RechargeStationStatus.IDLE;
    }

    private static void spawnChargingParticles(Level level, BlockPos blockPos, BlockState blockState) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x = (double)blockPos.m_123341_() + 0.5;
            double z = (double)blockPos.m_123343_() + 0.5;
            switch ((Direction)blockState.m_61143_((Property)RechargeStationBlock.FACING)) {
                case NORTH: {
                    z -= 0.15;
                    break;
                }
                case SOUTH: {
                    z += 0.15;
                    break;
                }
                case WEST: {
                    x -= 0.15;
                    break;
                }
                case EAST: {
                    x += 0.15;
                    break;
                }
            }
            for (int i = 0; i < 2; ++i) {
                double offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.2;
                double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.2;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x + offsetX, (double)blockPos.m_123342_() + 0.75, z + offsetZ, 1, 0.0, 0.05, 0.0, 0.01);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x + offsetX, (double)blockPos.m_123342_() + 0.2, z + offsetZ, 1, 0.0, 0.05, 0.0, 0.01);
            }
        }
    }

    private static void playChargingSound(Level level, BlockPos blockPos) {
        level.m_5594_(null, blockPos, SoundEvents.f_11737_, SoundSource.BLOCKS, 0.15f, 1.8f);
    }

    @Override
    public int getLastEnergyReceiveAmount() {
        return this.energyContainerData.m_6413_(4);
    }

    @Override
    public void setLastEnergyReceiveAmount(int amount) {
        this.energyContainerData.m_8050_(4, amount);
        if (this.f_58857_ != null) {
            this.lastEnergyReceiveTick = this.f_58857_.m_46467_();
        }
    }

    @Override
    public int getLastEnergyDistributeAmount() {
        return this.energyContainerData.m_6413_(5);
    }

    @Override
    public void setLastEnergyDistributeAmount(int amount) {
        this.energyContainerData.m_8050_(5, amount);
        if (this.f_58857_ != null) {
            this.lastEnergyDistributeTick = this.f_58857_.m_46467_();
        }
    }

    public RechargeStationContainer getContainer() {
        return this.container;
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.container.getItems();
    }

    @Override
    protected WorldlyContainer getContainerDelegate() {
        return this.container;
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.progress = compoundTag.m_128451_(PROGRESS_TAG);
        this.maxProgress = compoundTag.m_128451_(MAX_PROGRESS_TAG);
        this.statusDelayTimer = compoundTag.m_128451_(STATUS_DELAY_TIMER_TAG);
        this.loadEnergyPowerConsumer(compoundTag);
        this.energyData = this.getEnergyData();
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_(PROGRESS_TAG, this.progress);
        compoundTag.m_128405_(MAX_PROGRESS_TAG, this.maxProgress);
        compoundTag.m_128405_(STATUS_DELAY_TIMER_TAG, this.statusDelayTimer);
        this.saveEnergyPowerConsumer(compoundTag);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)TRANSLATION_KEY);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new RechargeStationMenu(windowId, playerInventory, this, this.containerData);
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    @Override
    public ContainerData getEnergyPowerData() {
        return this.energyContainerData;
    }

    private void syncToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.syncToClient();
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public EnergyPowerData getEnergyData() {
        return this.energyData;
    }

    @Override
    public void setEnergyData(EnergyPowerData data) {
        ItemStack currentBattery = this.container.m_8020_(1);
        this.energyData = data.withBattery(currentBattery);
        this.container.m_6836_(1, this.energyData.battery());
        this.m_6596_();
    }

    @Override
    public int getEnergyCapacity() {
        return 10000;
    }

    @Override
    public void markDirty() {
        this.m_6596_();
    }

    public ItemStack getInputItem() {
        return this.container.m_8020_(0);
    }

    public int getProgress() {
        return this.progress;
    }
}

