/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.windturbine;

import de.markusbordihn.scraptechworkshop.block.entity.AbstractWorkshopBlockEntity;
import de.markusbordihn.scraptechworkshop.block.entity.windturbine.ScrapWindTurbineContainer;
import de.markusbordihn.scraptechworkshop.block.windturbine.ScrapWindTurbineBlock;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyFlowStatus;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyPowerData;
import de.markusbordihn.scraptechworkshop.data.windturbine.ScrapWindTurbineStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerBatteryHandler;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerGenerator;
import de.markusbordihn.scraptechworkshop.environment.WindCalculator;
import de.markusbordihn.scraptechworkshop.menu.ScrapWindTurbineMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ScrapWindTurbineBlockEntity
extends AbstractWorkshopBlockEntity
implements EnergyPowerGenerator,
EnergyPowerBatteryHandler {
    public static final String ID = "scrap_wind_turbine";
    private static final int ENERGY_CAPACITY_MAH = 5000;
    private static final int ENERGY_GENERATION_INTERVAL = 20;
    private static final int ENERGY_DISTRIBUTION_INTERVAL = 1;
    private static final int WIND_CHECK_INTERVAL = 200;
    private static final String WIND_SPEED_TAG = "WindSpeed";
    private static final String POWER_GENERATION_TAG = "PowerGeneration";
    private static final int WIND_SPEED_DATA_INDEX = 0;
    private static final int POWER_GENERATION_DATA_INDEX = 1;
    private static final String TRANSLATION_KEY = "container.scrap_tech_workshop.scrap_wind_turbine";
    private static final int ENERGY_FLOW_DISPLAY_TICKS = 40;
    public static BlockEntityType<ScrapWindTurbineBlockEntity> TYPE;
    private final ScrapWindTurbineContainer container;
    private final int windCheckOffset;
    private final ContainerData energyContainerData = this.createEnergyContainerData();
    private int windSpeed = 0;
    private int powerGeneration = 0;
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ScrapWindTurbineBlockEntity.this.windSpeed;
                case 1 -> ScrapWindTurbineBlockEntity.this.powerGeneration;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ScrapWindTurbineBlockEntity.this.windSpeed = value;
                    break;
                }
                case 1: {
                    ScrapWindTurbineBlockEntity.this.powerGeneration = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private EnergyPowerData energyData = EnergyPowerData.empty();
    private long lastEnergyReceiveTick = 0L;
    private long lastEnergyDistributeTick = 0L;
    private int tickCounter = 0;

    public ScrapWindTurbineBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(TYPE, blockPos, blockState);
        this.container = new ScrapWindTurbineContainer(2, this::m_6596_);
        this.windCheckOffset = Math.abs((blockPos.m_123341_() * 31 + blockPos.m_123342_() * 17 + blockPos.m_123343_() * 13) % 200);
        this.energyData = EnergyPowerData.empty();
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, ScrapWindTurbineBlockEntity blockEntity) {
        ScrapWindTurbineStatus newStatus;
        if (level.f_46443_) {
            return;
        }
        ++blockEntity.tickCounter;
        long currentTick = level.m_46467_();
        if (blockEntity.lastEnergyReceiveTick > 0L && currentTick - blockEntity.lastEnergyReceiveTick > 40L) {
            blockEntity.energyContainerData.m_8050_(4, 0);
            blockEntity.lastEnergyReceiveTick = 0L;
        }
        if (blockEntity.lastEnergyDistributeTick > 0L && currentTick - blockEntity.lastEnergyDistributeTick > 40L) {
            blockEntity.energyContainerData.m_8050_(5, 0);
            blockEntity.lastEnergyDistributeTick = 0L;
        }
        if ((blockEntity.tickCounter + blockEntity.windCheckOffset) % 200 == 0) {
            blockEntity.windSpeed = WindCalculator.calculateWindSpeed(level, blockPos.m_7494_());
            blockEntity.powerGeneration = WindCalculator.calculatePowerGeneration(blockEntity.windSpeed);
        }
        if (blockEntity.powerGeneration > 0 && blockEntity.tickCounter % 20 == 0) {
            blockEntity.generateEnergy(blockEntity.powerGeneration);
            blockEntity.updateEnergyFlow(level.m_46467_());
        }
        if (blockEntity.tickCounter % 1 == 0) {
            int adaptiveRate = blockEntity.getAdaptiveTransferRate(blockEntity.getEnergyTransferRate());
            blockEntity.distributeEnergy(level, blockPos, 1, adaptiveRate);
        }
        if ((newStatus = blockEntity.determineStatus()) != blockState.m_61143_(ScrapWindTurbineBlock.STATUS)) {
            ScrapWindTurbineBlock.updateStatus(level, blockPos, newStatus);
        }
        if (blockEntity.tickCounter % 20 == 0) {
            blockEntity.m_6596_();
        }
    }

    @Override
    public int getLastEnergyReceiveAmount() {
        return this.energyContainerData.m_6413_(4);
    }

    @Override
    public void setLastEnergyReceiveAmount(int amount) {
        this.energyContainerData.m_8050_(4, amount);
        if (this.f_58857_ != null) {
            this.lastEnergyReceiveTick = this.f_58857_.m_46467_();
        }
    }

    @Override
    public int getLastEnergyDistributeAmount() {
        return this.energyContainerData.m_6413_(5);
    }

    @Override
    public void setLastEnergyDistributeAmount(int amount) {
        this.energyContainerData.m_8050_(5, amount);
        if (this.f_58857_ != null) {
            this.lastEnergyDistributeTick = this.f_58857_.m_46467_();
        }
    }

    private ScrapWindTurbineStatus determineStatus() {
        if (this.f_58857_ != null && !this.f_58857_.m_45527_(this.m_58899_().m_7494_())) {
            return ScrapWindTurbineStatus.ERROR;
        }
        if (this.windSpeed == 0) {
            return ScrapWindTurbineStatus.NO_WIND;
        }
        if (this.windSpeed < 30) {
            return ScrapWindTurbineStatus.LOW_WIND;
        }
        if (this.powerGeneration > 0) {
            return ScrapWindTurbineStatus.GENERATING;
        }
        return ScrapWindTurbineStatus.IDLE;
    }

    public int getWindSpeed() {
        return this.windSpeed;
    }

    public ScrapWindTurbineContainer getContainer() {
        return this.container;
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.container.getItems();
    }

    @Override
    protected WorldlyContainer getContainerDelegate() {
        return this.container;
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.windSpeed = compoundTag.m_128451_(WIND_SPEED_TAG);
        this.powerGeneration = compoundTag.m_128451_(POWER_GENERATION_TAG);
        this.loadEnergyPowerGenerator(compoundTag);
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_(WIND_SPEED_TAG, this.windSpeed);
        compoundTag.m_128405_(POWER_GENERATION_TAG, this.powerGeneration);
        this.saveEnergyPowerGenerator(compoundTag);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)TRANSLATION_KEY);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new ScrapWindTurbineMenu(windowId, playerInventory, this, this.containerData);
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    @Override
    public ContainerData getEnergyPowerData() {
        return this.energyContainerData;
    }

    private void syncToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.syncToClient();
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public EnergyPowerData getEnergyData() {
        return this.energyData;
    }

    @Override
    public void setEnergyData(EnergyPowerData data) {
        ItemStack currentBattery = this.container.m_8020_(0);
        this.energyData = data.withBattery(currentBattery);
        this.container.m_6836_(0, this.energyData.battery());
        this.m_6596_();
    }

    @Override
    public int getEnergyCapacity() {
        return 5000;
    }

    @Override
    public void markDirty() {
        this.m_6596_();
    }

    @Override
    public int getChargeCycleCount() {
        return this.getEnergyData().chargeCycleCount();
    }

    @Override
    public void setChargeCycleCount(int count) {
        this.setEnergyData(this.getEnergyData().withChargeCycleCount(count));
    }

    @Override
    public long getLastEnergyChangeTime() {
        return this.getEnergyData().lastEnergyChangeTime();
    }

    @Override
    public void setLastEnergyChangeTime(long time) {
        this.setEnergyData(this.getEnergyData().withLastEnergyChangeTime(time));
    }

    @Override
    public int getLastEnergyLevel() {
        return this.getEnergyData().lastEnergyLevel();
    }

    @Override
    public void setLastEnergyLevel(int level) {
        this.setEnergyData(this.getEnergyData().withLastEnergyLevel(level));
    }

    @Override
    public EnergyFlowStatus getEnergyFlowStatus() {
        return this.getEnergyData().energyFlowStatus();
    }

    @Override
    public void setEnergyFlowStatus(EnergyFlowStatus status) {
        this.setEnergyData(this.getEnergyData().withEnergyFlowStatus(status));
    }
}

