/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.recycler;

import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerBlockEntity;
import de.markusbordihn.scraptechworkshop.data.recycler.RecyclerStatus;
import de.markusbordihn.scraptechworkshop.menu.MenuManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RecyclerBlock
extends BaseEntityBlock {
    public static final String ID = "recycler";
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<RecyclerStatus> STATUS = EnumProperty.m_61587_((String)"status", RecyclerStatus.class);
    private static final VoxelShape SHAPE_NORTH_SOUTH = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);

    public RecyclerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_(STATUS, (Comparable)((Object)RecyclerStatus.IDLE)));
    }

    public static void updateStatus(Level level, BlockPos blockPos, RecyclerStatus newStatus) {
        BlockState currentState = level.m_8055_(blockPos);
        if (currentState.m_60734_() instanceof RecyclerBlock && currentState.m_61143_(STATUS) != newStatus) {
            level.m_7731_(blockPos, (BlockState)currentState.m_61124_(STATUS, (Comparable)((Object)newStatus)), 3);
        }
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        return switch (facing) {
            case Direction.NORTH, Direction.SOUTH -> SHAPE_NORTH_SOUTH;
            case Direction.EAST, Direction.WEST -> SHAPE_EAST_WEST;
            default -> SHAPE_NORTH_SOUTH;
        };
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new RecyclerBlockEntity(blockPos, blockState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return RecyclerBlock.m_152132_(blockEntityType, RecyclerBlockEntity.TYPE, RecyclerBlockEntity::tick);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(blockPos)) instanceof RecyclerBlockEntity) {
            RecyclerBlockEntity recyclerBlockEntity = (RecyclerBlockEntity)blockEntity;
            this.openRecyclerMenu(player, recyclerBlockEntity);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private void openRecyclerMenu(Player player, RecyclerBlockEntity recyclerBlockEntity) {
        MenuManager.openMenu(player, recyclerBlockEntity);
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!blockState.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof RecyclerBlockEntity) {
                RecyclerBlockEntity recyclerBlockEntity = (RecyclerBlockEntity)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)recyclerBlockEntity.getContainer());
            }
            super.m_6810_(blockState, level, blockPos, newState, isMoving);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_(STATUS, (Comparable)((Object)RecyclerStatus.IDLE));
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED, STATUS});
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof RecyclerBlockEntity) {
            RecyclerBlockEntity recyclerBlockEntity = (RecyclerBlockEntity)blockEntity;
            return recyclerBlockEntity.getRedstoneSignal();
        }
        return 0;
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        int spaceAvailable;
        if (level.f_46443_ || !(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof RecyclerBlockEntity)) {
            return;
        }
        RecyclerBlockEntity recyclerBlockEntity = (RecyclerBlockEntity)blockEntity;
        ItemStack droppedStack = itemEntity.m_32055_();
        if (droppedStack.m_41619_()) {
            return;
        }
        ItemStack inputStack = recyclerBlockEntity.getContainer().m_8020_(0);
        if (inputStack.m_41619_()) {
            recyclerBlockEntity.getContainer().m_6836_(0, droppedStack.m_41777_());
            itemEntity.m_146870_();
        } else if (ItemStack.m_150942_((ItemStack)inputStack, (ItemStack)droppedStack) && (spaceAvailable = inputStack.m_41741_() - inputStack.m_41613_()) > 0) {
            int toTransfer = Math.min(spaceAvailable, droppedStack.m_41613_());
            inputStack.m_41769_(toTransfer);
            droppedStack.m_41774_(toTransfer);
            if (droppedStack.m_41619_()) {
                itemEntity.m_146870_();
            }
        }
    }
}

