/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.scrap;

import de.markusbordihn.scraptechworkshop.block.scrap.ScrapPileBlock;
import de.markusbordihn.scraptechworkshop.data.ScrapPileVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapPileMerger {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final int MAX_SIZE = 4;

    private ScrapPileMerger() {
    }

    public static boolean attemptMergeWithNeighbors(Level level, BlockPos pos, BlockState state) {
        ScrapPileVariant variant = (ScrapPileVariant)((Object)state.m_61143_(ScrapPileBlock.VARIANT));
        int currentSize = (Integer)state.m_61143_((Property)ScrapPileBlock.SIZE);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_121945_(direction);
            BlockState neighborState = level.m_8055_(neighborPos);
            if (!(neighborState.m_60734_() instanceof ScrapPileBlock) || neighborState.m_61143_(ScrapPileBlock.VARIANT) != variant) continue;
            int neighborSize = (Integer)neighborState.m_61143_((Property)ScrapPileBlock.SIZE);
            int totalSize = currentSize + neighborSize;
            if (totalSize <= 4) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ScrapPileBlock.SIZE, (Comparable)Integer.valueOf(totalSize)), 3);
                level.m_7471_(neighborPos, false);
                log.debug("Merged scrap piles at {} and {} in dimension {} - Combined size: {}, Variant: {}", (Object)pos, (Object)neighborPos, (Object)level.m_46472_().m_135782_(), (Object)totalSize, (Object)variant);
            } else {
                int overflow = totalSize - 4;
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ScrapPileBlock.SIZE, (Comparable)Integer.valueOf(4)), 3);
                level.m_7731_(neighborPos, (BlockState)neighborState.m_61124_((Property)ScrapPileBlock.SIZE, (Comparable)Integer.valueOf(overflow)), 3);
                log.debug("Partially merged scrap piles at {} and {} in dimension {} - Main: 4, Overflow: {}, Variant: {}", (Object)pos, (Object)neighborPos, (Object)level.m_46472_().m_135782_(), (Object)overflow, (Object)variant);
            }
            return true;
        }
        return false;
    }
}

