/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.scrapbox;

import de.markusbordihn.scraptechworkshop.data.scrap.ScrapType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ScrapBoxBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty STACKING = IntegerProperty.m_61631_((String)"stacking", (int)1, (int)4);
    private static final VoxelShape SHAPE_NORTH_1 = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH_1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST_1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    private static final VoxelShape SHAPE_EAST_1 = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_NORTH_2 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH_2 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST_2 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST_2 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_NORTH_3 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH_3 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST_3 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST_3 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_FULL = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected final ScrapType scrapType;

    public ScrapBoxBlock(BlockBehaviour.Properties properties, ScrapType scrapType) {
        super(properties);
        this.scrapType = scrapType;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)STACKING, (Comparable)Integer.valueOf(1)));
    }

    public ScrapBoxBlock(ScrapType scrapType) {
        this(BlockBehaviour.Properties.m_284310_().m_284180_(scrapType.getMapColor()).m_60913_(1.5f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60953_(scrapType.isLuminous() ? state -> 7 : state -> 0), scrapType);
    }

    public ScrapType getScrapType() {
        return this.scrapType;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ScrapBoxBlock scrapBoxBlock;
        BlockItem blockItem;
        Block heldBlock;
        ItemStack heldItem = player.m_21120_(hand);
        int currentStacking = (Integer)state.m_61143_((Property)STACKING);
        if (heldItem.m_41619_()) {
            if (currentStacking > 1) {
                if (!level.f_46443_) {
                    if (!player.m_150110_().f_35937_ || player.m_6047_()) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)STACKING, (Comparable)Integer.valueOf(currentStacking - 1)), 3);
                    }
                    ScrapBoxBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this, 1));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        }
        Item item = heldItem.m_41720_();
        if (item instanceof BlockItem && (heldBlock = (blockItem = (BlockItem)item).m_40614_()) instanceof ScrapBoxBlock && (scrapBoxBlock = (ScrapBoxBlock)heldBlock).getScrapType() == this.scrapType && currentStacking < 4) {
            if (!level.f_46443_) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)STACKING, (Comparable)Integer.valueOf(currentStacking + 1)), 3);
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_ && !player.m_7500_()) {
            int stacking = (Integer)state.m_61143_((Property)STACKING);
            ItemStack itemStack = new ItemStack((ItemLike)this, stacking);
            ScrapBoxBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)itemStack);
        }
        super.m_5707_(level, pos, state, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, STACKING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return switch ((Integer)state.m_61143_((Property)STACKING)) {
            case 1 -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case SOUTH: {
                        yield SHAPE_SOUTH_1;
                    }
                    case WEST: {
                        yield SHAPE_WEST_1;
                    }
                    case EAST: {
                        yield SHAPE_EAST_1;
                    }
                }
                yield SHAPE_NORTH_1;
            }
            case 2 -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case SOUTH: {
                        yield SHAPE_SOUTH_2;
                    }
                    case WEST: {
                        yield SHAPE_WEST_2;
                    }
                    case EAST: {
                        yield SHAPE_EAST_2;
                    }
                }
                yield SHAPE_NORTH_2;
            }
            case 3 -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case SOUTH: {
                        yield SHAPE_SOUTH_3;
                    }
                    case WEST: {
                        yield SHAPE_WEST_3;
                    }
                    case EAST: {
                        yield SHAPE_EAST_3;
                    }
                }
                yield SHAPE_NORTH_3;
            }
            default -> SHAPE_FULL;
        };
    }
}

