/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerBlockEntity;
import de.markusbordihn.scraptechworkshop.block.recycler.RecyclerBlock;
import de.markusbordihn.scraptechworkshop.data.recycler.RecyclerStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RecyclerBlockEntityRenderer
implements BlockEntityRenderer<RecyclerBlockEntity> {
    private static final int INPUT_SLOT = 0;
    private static final int PROGRESS_DATA_INDEX = 0;
    private static final int MAX_PROGRESS_DATA_INDEX = 1;
    private static final double ITEM_X_OFFSET = 0.5;
    private static final double ITEM_Y_OFFSET = 0.85;
    private static final double ITEM_Z_OFFSET = 0.56;
    private static final float INITIAL_SCALE = 0.4f;
    private static final float FINAL_SCALE = 0.01f;
    private static final float ANIMATION_SPEED_MULTIPLIER = 2.0f;
    private static final float DOWNWARD_MOVEMENT_FACTOR = 0.3f;
    private static final int PARTICLE_SPAWN_INTERVAL = 30;
    private static final int DUST_PARTICLE_INTERVAL = 40;
    private static final float DUST_PARTICLE_CHANCE = 0.3f;
    private static final double CLOSE_RENDER_DISTANCE_SQUARED = 256.0;
    private static final int PROXIMITY_CHECK_INTERVAL = 20;
    private final ItemRenderer itemRenderer;
    private long lastProximityCheck = -1L;
    private boolean cachedPlayerNearby = false;
    private BlockPos lastCheckedPos = null;

    public RecyclerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
    }

    public void render(RecyclerBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = blockEntity.m_58904_();
        if (level == null || !level.f_46443_) {
            return;
        }
        RecyclerStatus status = (RecyclerStatus)((Object)blockEntity.m_58900_().m_61143_(RecyclerBlock.STATUS));
        if (status != RecyclerStatus.WORKING) {
            return;
        }
        ItemStack inputStack = blockEntity.m_8020_(0);
        if (inputStack.m_41619_()) {
            return;
        }
        if (this.isSolidBlockAbove(level, blockEntity.m_58899_())) {
            return;
        }
        if (!this.isPlayerNearbyCached(level, blockEntity.m_58899_())) {
            return;
        }
        float progress = this.getProcessingProgress(blockEntity, partialTick);
        if (progress <= 0.0f) {
            return;
        }
        this.addParticleEffects(blockEntity, level, inputStack);
        this.renderAnimatedItem(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay, inputStack, level, progress);
    }

    private void renderAnimatedItem(RecyclerBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, ItemStack inputStack, Level level, float progress) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.85, 0.56);
        Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)RecyclerBlock.FACING);
        switch (facing) {
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
        }
        long gameTime = level.m_46467_();
        float animationTime = (float)gameTime + partialTick;
        int rotationAxis = (int)(gameTime % 3L);
        float rotation = animationTime * 2.0f % 360.0f;
        float scale = Mth.m_14179_((float)progress, (float)0.4f, (float)0.01f);
        float scaleReduction = 0.4f - scale;
        float downwardMovement = scaleReduction * 0.3f;
        poseStack.m_252880_(0.0f, -downwardMovement, 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        switch (rotationAxis) {
            case 0: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(rotation));
                break;
            }
            case 1: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
                break;
            }
            case 2: {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation));
                break;
            }
            default: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
            }
        }
        this.itemRenderer.m_269128_(inputStack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, level, (int)blockEntity.m_58899_().m_121878_());
        poseStack.m_85849_();
    }

    private void addParticleEffects(RecyclerBlockEntity blockEntity, Level level, ItemStack inputStack) {
        long gameTime = level.m_46467_();
        if (gameTime % 30L != 0L) {
            return;
        }
        double blockX = (double)blockEntity.m_58899_().m_123341_() + 0.5;
        double blockY = (double)blockEntity.m_58899_().m_123342_() + 0.75;
        double blockZ = (double)blockEntity.m_58899_().m_123343_() + 0.5;
        double offsetX = (level.m_213780_().m_188500_() - 0.5) * 0.0375;
        double offsetY = (level.m_213780_().m_188500_() - 0.5) * 0.025;
        double offsetZ = (level.m_213780_().m_188500_() - 0.5) * 0.0375;
        double velocityX = (level.m_213780_().m_188500_() - 0.5) * 0.0025;
        double velocityY = level.m_213780_().m_188500_() * 0.00125;
        double velocityZ = (level.m_213780_().m_188500_() - 0.5) * 0.0025;
        ItemParticleOption particleOption = new ItemParticleOption(ParticleTypes.f_123752_, inputStack);
        level.m_7106_((ParticleOptions)particleOption, blockX + offsetX, blockY + offsetY, blockZ + offsetZ, velocityX, velocityY, velocityZ);
        if (gameTime % 40L == 0L && level.m_213780_().m_188501_() < 0.3f) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, blockX + (level.m_213780_().m_188500_() - 0.5) * 0.025, blockY + 0.0125, blockZ + (level.m_213780_().m_188500_() - 0.5) * 0.025, 0.0, 0.0025, 0.0);
        }
    }

    private float getProcessingProgress(RecyclerBlockEntity blockEntity, float partialTick) {
        int progress = blockEntity.getContainerData().m_6413_(0);
        int maxProgress = blockEntity.getContainerData().m_6413_(1);
        if (maxProgress <= 0) {
            return 0.0f;
        }
        return Math.min(1.0f, ((float)progress + partialTick) / (float)maxProgress);
    }

    private boolean isSolidBlockAbove(Level level, BlockPos pos) {
        BlockPos abovePos = pos.m_7494_();
        BlockState stateAbove = level.m_8055_(abovePos);
        return stateAbove.m_60804_((BlockGetter)level, abovePos);
    }

    private boolean isPlayerNearbyCached(Level level, BlockPos pos) {
        long currentTime = level.m_46467_();
        if (this.lastProximityCheck == -1L || currentTime - this.lastProximityCheck >= 20L || !pos.equals((Object)this.lastCheckedPos)) {
            this.lastProximityCheck = currentTime;
            this.lastCheckedPos = pos.m_7949_();
            this.cachedPlayerNearby = this.calculatePlayerNearby(level, pos);
        }
        return this.cachedPlayerNearby;
    }

    private boolean calculatePlayerNearby(Level level, BlockPos pos) {
        double deltaZ;
        double deltaY;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return false;
        }
        double deltaX = player.m_20185_() - ((double)pos.m_123341_() + 0.5);
        double distanceSquared = deltaX * deltaX + (deltaY = player.m_20186_() - ((double)pos.m_123342_() + 0.5)) * deltaY + (deltaZ = player.m_20189_() - ((double)pos.m_123343_() + 0.5)) * deltaZ;
        return distanceSquared <= 256.0;
    }
}

