/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.blockentity.windturbine;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.scraptechworkshop.block.entity.windturbine.ScrapWindTurbineBlockEntity;
import de.markusbordihn.scraptechworkshop.block.multiblock.MultiBlockStructure;
import de.markusbordihn.scraptechworkshop.block.windturbine.ScrapWindTurbineBlock;
import de.markusbordihn.scraptechworkshop.data.windturbine.ScrapWindTurbineStatus;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;

public class ScrapWindTurbineBlockEntityRenderer
implements BlockEntityRenderer<ScrapWindTurbineBlockEntity> {
    private final ItemRenderer itemRenderer;
    private final ItemStack bladesItem;
    private final Map<ScrapWindTurbineBlockEntity, Float> rotationMap = new HashMap<ScrapWindTurbineBlockEntity, Float>();

    public ScrapWindTurbineBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
        this.bladesItem = new ItemStack((ItemLike)ModItems.SCRAP_WIND_TURBINE_BLADES.get());
    }

    public void render(ScrapWindTurbineBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState blockState = blockEntity.m_58900_();
        if (blockState.m_61143_(MultiBlockStructure.HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        ScrapWindTurbineStatus status = (ScrapWindTurbineStatus)((Object)blockState.m_61143_(ScrapWindTurbineBlock.STATUS));
        if (status == ScrapWindTurbineStatus.ERROR) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.0, 0.5);
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        float rotation = this.rotationMap.getOrDefault(blockEntity, Float.valueOf(0.0f)).floatValue();
        if (blockEntity.getWindSpeed() > 0) {
            if ((rotation += partialTick * (float)blockEntity.getWindSpeed() * 0.05f) > 3600.0f) {
                rotation -= 3600.0f;
            }
            this.rotationMap.put(blockEntity, Float.valueOf(rotation));
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        this.itemRenderer.m_269128_(this.bladesItem, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.m_58904_(), 0);
        poseStack.m_85849_();
    }
}

