/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.entity.robot.layers;

import de.markusbordihn.scraptechworkshop.client.renderer.entity.robot.layers.RobotEyesLayer;
import de.markusbordihn.scraptechworkshop.data.collectorstation.CollectorStationStatus;
import de.markusbordihn.scraptechworkshop.entity.robot.BaseRobotEntity;
import de.markusbordihn.scraptechworkshop.entity.robot.collectorstationrobot.CollectorStationRobotEntity;
import de.markusbordihn.scraptechworkshop.entity.robot.collectorstationrobot.CollectorStationRobotStaticEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;

public class CollectorStationRobotEyesLayer<T extends BaseRobotEntity, M extends EntityModel<T>>
extends RobotEyesLayer<T, M> {
    private static final ResourceLocation EYES_IDLE = new ResourceLocation("scrap_tech_workshop", "textures/entity/robot/collector_station_robot/eyes_idle.png");
    private static final ResourceLocation EYES_COLLECTING = new ResourceLocation("scrap_tech_workshop", "textures/entity/robot/collector_station_robot/eyes_collecting.png");
    private static final ResourceLocation EYES_RETURNING = new ResourceLocation("scrap_tech_workshop", "textures/entity/robot/collector_station_robot/eyes_returning.png");
    private static final ResourceLocation EYES_CHARGING = new ResourceLocation("scrap_tech_workshop", "textures/entity/robot/collector_station_robot/eyes_charging.png");
    private static final ResourceLocation EYES_ERROR = new ResourceLocation("scrap_tech_workshop", "textures/entity/robot/collector_station_robot/eyes_error.png");

    public CollectorStationRobotEyesLayer(RenderLayerParent<T, M> parent) {
        super(parent);
    }

    @Override
    protected ResourceLocation getEyeTexture(T entity) {
        CollectorStationStatus status = this.getStatus(entity);
        if (status == null) {
            return EYES_IDLE;
        }
        switch (status) {
            case COLLECTING: {
                return EYES_COLLECTING;
            }
            case RETURNING: {
                return EYES_RETURNING;
            }
            case CHARGING: {
                return EYES_CHARGING;
            }
            case NO_POWER: 
            case NO_STORAGE: {
                return EYES_ERROR;
            }
        }
        return EYES_IDLE;
    }

    private CollectorStationStatus getStatus(T entity) {
        if (entity instanceof CollectorStationRobotEntity) {
            return ((CollectorStationRobotEntity)((Object)entity)).getStatus();
        }
        if (entity instanceof CollectorStationRobotStaticEntity) {
            return ((CollectorStationRobotStaticEntity)((Object)entity)).getStatus();
        }
        return null;
    }
}

