/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.hololog;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogPlaybackBase;
import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogPlayerEffects;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogData;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogDisplayEntity;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogLine;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogPlaybackContext;
import de.markusbordihn.scraptechworkshop.entity.hololog.HoloLogHumanoidEntity;
import de.markusbordihn.scraptechworkshop.registry.entity.HoloLogEntityRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class HoloLogBlockPlayer
extends HoloLogPlaybackBase {
    private static final int CHECKS_PER_SECOND = 10;
    private static final float CHECK_INTERVAL = 0.1f;
    private final Consumer<String> textDisplay;
    private final Map<ResourceLocation, Entity> entityCache = new HashMap<ResourceLocation, Entity>();
    private final float ticksPerCheck;
    private float elapsedTime = 0.0f;
    private float endDelayTimer = 0.0f;
    private boolean waitingForEndDelay = false;
    private int ticksSinceLastCheck = 0;

    public HoloLogBlockPlayer(HoloLogData holoLogData, HoloLogPlaybackContext context, UUID playerId, Consumer<String> textDisplay, Runnable onComplete) {
        super(holoLogData, context, playerId, onComplete);
        this.textDisplay = textDisplay;
        this.ticksPerCheck = 2.0f;
    }

    @Override
    protected void onPlaybackStart() {
        this.elapsedTime = 0.0f;
        this.endDelayTimer = 0.0f;
        this.waitingForEndDelay = false;
        this.ticksSinceLastCheck = 0;
        if (this.textDisplay != null) {
            Object titleText = Component.m_237113_((String)this.holoLogData.title()).getString();
            if (!this.holoLogData.subtitle().isEmpty()) {
                titleText = (String)titleText + " - " + this.holoLogData.subtitle();
            }
            this.textDisplay.accept((String)titleText);
            log.debug("Displayed title: {}", titleText);
        }
    }

    @Override
    protected void onPlaybackStop() {
    }

    @Override
    protected int getDisplayLineIndex() {
        HoloLogLine line;
        int lineIndex = -1;
        int i = 0;
        while (i < this.holoLogData.lines().size() && this.elapsedTime >= (line = this.holoLogData.lines().get(i)).startTime()) {
            lineIndex = i++;
        }
        return lineIndex;
    }

    @Override
    public void tick() {
        if (this.state != HoloLogPlaybackBase.PlaybackState.PLAYING) {
            return;
        }
        Level level = this.context.getLevel();
        if (level == null || !(level instanceof ClientLevel)) {
            log.warn("Level is null or not ClientLevel, stopping playback");
            this.state = HoloLogPlaybackBase.PlaybackState.STOPPED;
            return;
        }
        ++this.ticksSinceLastCheck;
        if ((float)this.ticksSinceLastCheck >= this.ticksPerCheck) {
            HoloLogLine line;
            this.elapsedTime += 0.1f;
            this.ticksSinceLastCheck = 0;
            this.startVoiceOver(this.elapsedTime);
            if (this.currentLineIndex < this.holoLogData.lines().size() && this.elapsedTime >= (line = this.holoLogData.lines().get(this.currentLineIndex)).startTime()) {
                float effectiveDelay = line.lineDelay() > 0.0f ? line.lineDelay() : this.holoLogData.lineDelay();
                log.debug("Displaying line {}/{}: '{}' at {}s (start time: {}s, delay: {}s)", (Object)(this.currentLineIndex + 1), (Object)this.holoLogData.lines().size(), (Object)(line.text().isEmpty() ? "<pause>" : line.text()), (Object)Float.valueOf(this.elapsedTime), (Object)Float.valueOf(line.startTime()), (Object)Float.valueOf(effectiveDelay));
                if (this.textDisplay != null && !line.text().isEmpty()) {
                    this.textDisplay.accept(line.text());
                }
                HoloLogPlayerEffects.playEffects(line.effects(), this.context, this.context.getEffectPosition());
                ++this.currentLineIndex;
            }
            if (this.currentLineIndex >= this.holoLogData.lines().size() && !this.waitingForEndDelay) {
                this.waitingForEndDelay = true;
                this.endDelayTimer = 0.0f;
                log.debug("All lines finished, waiting {}s before end effects", (Object)Float.valueOf(this.holoLogData.endDelay()));
            }
            if (this.waitingForEndDelay) {
                this.endDelayTimer += 0.1f;
                if (this.endDelayTimer >= this.holoLogData.endDelay()) {
                    this.completePlayback();
                }
            }
        }
    }

    @Override
    protected void renderEntity(PoseStack poseStack, ResourceLocation entityId, float partialTick, int lightLevel) {
        Minecraft mc = Minecraft.m_91087_();
        this.renderEntity(poseStack, (MultiBufferSource)mc.m_91269_().m_110104_(), entityId, partialTick, lightLevel);
    }

    @Override
    protected void renderEntity(PoseStack poseStack, MultiBufferSource buffer, ResourceLocation entityId, float partialTick, int lightLevel) {
        Level level = this.context.getLevel();
        Entity entity = this.getOrCreateEntity(level, entityId);
        if (entity == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher dispatcher = mc.m_91290_();
        EntityRenderer renderer = dispatcher.m_114382_(entity);
        if (level != null) {
            entity.f_19797_ = (int)level.m_46467_();
        }
        renderer.m_7392_(entity, 0.0f, 0.0f, poseStack, buffer, lightLevel);
    }

    @Override
    protected void renderHoloEntity(PoseStack poseStack, HoloLogDisplayEntity displayEntity, float partialTick, int lightLevel) {
        Minecraft mc = Minecraft.m_91087_();
        this.renderHoloEntity(poseStack, (MultiBufferSource)mc.m_91269_().m_110104_(), displayEntity, partialTick, lightLevel);
    }

    @Override
    protected void renderHoloEntity(PoseStack poseStack, MultiBufferSource buffer, HoloLogDisplayEntity displayEntity, float partialTick, int lightLevel) {
        Level level = this.context.getLevel();
        HoloLogHumanoidEntity holoEntity = this.getOrCreateHoloEntity(level, displayEntity);
        if (holoEntity == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        EntityRenderDispatcher dispatcher = minecraft.m_91290_();
        EntityRenderer renderer = dispatcher.m_114382_((Entity)holoEntity);
        if (level != null) {
            holoEntity.f_19797_ = (int)level.m_46467_();
        }
        renderer.m_7392_((Entity)holoEntity, 0.0f, 0.0f, poseStack, buffer, lightLevel);
    }

    @Override
    protected void renderBlock(PoseStack poseStack, ResourceLocation blockId, int lightLevel) {
        Minecraft mc = Minecraft.m_91087_();
        this.renderBlock(poseStack, (MultiBufferSource)mc.m_91269_().m_110104_(), blockId, lightLevel);
    }

    @Override
    protected void renderBlock(PoseStack poseStack, MultiBufferSource buffer, ResourceLocation blockId, int lightLevel) {
        Minecraft.m_91087_().m_91289_().m_110912_(((Block)BuiltInRegistries.f_256975_.m_7745_(blockId)).m_49966_(), poseStack, buffer, lightLevel, OverlayTexture.f_118083_);
    }

    @Override
    protected void renderItem(PoseStack poseStack, ResourceLocation itemId, int lightLevel) {
        Minecraft mc = Minecraft.m_91087_();
        this.renderItem(poseStack, (MultiBufferSource)mc.m_91269_().m_110104_(), itemId, lightLevel);
    }

    @Override
    protected void renderItem(PoseStack poseStack, MultiBufferSource buffer, ResourceLocation itemId, int lightLevel) {
        Minecraft.m_91087_().m_91291_().m_269128_(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(itemId)), ItemDisplayContext.GROUND, lightLevel, OverlayTexture.f_118083_, poseStack, buffer, this.context.getLevel(), 0);
    }

    private Entity getOrCreateEntity(Level level, ResourceLocation entityId) {
        Entity cached;
        if (level == null) {
            return null;
        }
        if (this.entityCache.containsKey(entityId) && (cached = this.entityCache.get(entityId)) != null && !cached.m_213877_()) {
            return cached;
        }
        Optional entityType = BuiltInRegistries.f_256780_.m_6612_(entityId);
        if (entityType.isEmpty()) {
            log.warn("Entity type not found: {}", (Object)entityId);
            return null;
        }
        Entity entity = ((EntityType)entityType.get()).m_20615_(level);
        if (entity != null) {
            entity.m_6842_(false);
            this.entityCache.put(entityId, entity);
        }
        return entity;
    }

    private HoloLogHumanoidEntity getOrCreateHoloEntity(Level level, HoloLogDisplayEntity displayEntity) {
        HoloLogHumanoidEntity holoEntity;
        Entity cached;
        if (level == null || HoloLogEntityRegistry.HOLO_LOG_HUMANOID_ENTITY_TYPE == null) {
            return null;
        }
        ResourceLocation cacheKey = displayEntity.texture();
        if (cacheKey == null) {
            cacheKey = new ResourceLocation("scrap_tech_workshop", "hololog_humanoid_default");
        }
        if (this.entityCache.containsKey(cacheKey) && (cached = this.entityCache.get(cacheKey)) instanceof HoloLogHumanoidEntity) {
            HoloLogHumanoidEntity holoEntity2 = (HoloLogHumanoidEntity)cached;
            if (!cached.m_213877_()) {
                return holoEntity2;
            }
        }
        if ((holoEntity = (HoloLogHumanoidEntity)HoloLogEntityRegistry.HOLO_LOG_HUMANOID_ENTITY_TYPE.m_20615_(level)) != null) {
            holoEntity.m_6842_(false);
            if (displayEntity.texture() != null) {
                holoEntity.setTexture(displayEntity.texture());
            }
            holoEntity.setSlim(displayEntity.slim());
            this.entityCache.put(cacheKey, (Entity)holoEntity);
        }
        return holoEntity;
    }
}

