/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.hololog;

import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogPlaybackContext;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class HoloLogPlayerAudio {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Map<UUID, SoundInstance> ACTIVE_VOICE_OVERS = new HashMap<UUID, SoundInstance>();

    private HoloLogPlayerAudio() {
    }

    public static void playVoiceOver(UUID playerId, ResourceLocation voiceOverId, HoloLogPlaybackContext context) {
        if (voiceOverId == null) {
            log.debug("No voice-over specified for player {}", (Object)playerId);
            return;
        }
        HoloLogPlayerAudio.stopVoiceOver(playerId);
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            String soundEventPath = voiceOverId.m_135815_().replace('/', '.');
            ResourceLocation soundEventId = new ResourceLocation(voiceOverId.m_135827_(), soundEventPath);
            if (!minecraft.m_91106_().m_120354_().contains(soundEventId)) {
                log.error("Voice-over sound '{}' is not registered in sounds.json! Make sure to add an entry for '{}' with the sound file at 'sounds/{}.ogg'", (Object)soundEventId, (Object)soundEventId, (Object)voiceOverId.m_135815_());
                return;
            }
            SoundEvent soundEvent = SoundEvent.m_262824_((ResourceLocation)soundEventId);
            SimpleSoundInstance soundInstance = new SimpleSoundInstance(soundEvent.m_11660_(), SoundSource.VOICE, 1.0f, 1.0f, SoundInstance.m_235150_(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
            minecraft.m_91106_().m_120367_((SoundInstance)soundInstance);
            ACTIVE_VOICE_OVERS.put(playerId, (SoundInstance)soundInstance);
            log.info("Started voice-over playback: {} (sound event: {}) for player {}", (Object)voiceOverId, (Object)soundEventId, (Object)playerId);
        }
        catch (Exception e) {
            log.error("Failed to play voice-over {}: {}", (Object)voiceOverId, (Object)e.getMessage(), (Object)e);
        }
    }

    public static void stopVoiceOver(UUID playerId) {
        SoundInstance soundInstance = ACTIVE_VOICE_OVERS.remove(playerId);
        if (soundInstance != null) {
            try {
                Minecraft.m_91087_().m_91106_().m_120399_(soundInstance);
                log.debug("Stopped voice-over for player {}", (Object)playerId);
            }
            catch (Exception e) {
                log.warn("Failed to stop voice-over for player {}: {}", (Object)playerId, (Object)e.getMessage());
            }
        }
    }

    public static void stopAll() {
        for (UUID playerId : ACTIVE_VOICE_OVERS.keySet()) {
            HoloLogPlayerAudio.stopVoiceOver(playerId);
        }
        ACTIVE_VOICE_OVERS.clear();
        log.debug("Stopped all voice-overs");
    }
}

