/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.scraptechworkshop.Constants;
import de.markusbordihn.scraptechworkshop.client.screen.energy.EnergyPowerRenderer;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyFlowStatus;
import de.markusbordihn.scraptechworkshop.menu.EnergyPowerGeneratorMenu;
import de.markusbordihn.scraptechworkshop.menu.EnergyPowerMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class BaseContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    public static final int STANDARD_BACKGROUND_WIDTH = 248;
    public static final int STANDARD_BACKGROUND_HEIGHT = 166;
    public static final int PROGRESS_BAR_BACKGROUND_COLOR = -11184811;
    public static final int PROGRESS_BAR_BORDER_COLOR = -16777216;

    protected BaseContainerScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    protected void renderDefaultBackground(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Constants.TEXTURE_DEMO_BACKGROUND);
        int splitX = Math.min(width / 2, 124);
        int splitY = Math.min(height / 2, 83);
        guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, x, y, 0, 0, Math.min(splitX, width), Math.min(splitY, height));
        if (width > splitX) {
            guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, x + splitX, y, 248 - (width - splitX), 0, width - splitX, Math.min(splitY, height));
        }
        if (height > splitY) {
            guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, x, y + splitY, 0, 166 - (height - splitY), Math.min(splitX, width), height - splitY);
        }
        if (width > splitX && height > splitY) {
            guiGraphics.m_280218_(Constants.TEXTURE_DEMO_BACKGROUND, x + splitX, y + splitY, 248 - (width - splitX), 166 - (height - splitY), width - splitX, height - splitY);
        }
    }

    protected void renderSlot(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Constants.TEXTURE_INVENTORY);
        guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, x - 1, y - 1, 7, 7, 18, 18);
    }

    protected void renderSlots(GuiGraphics guiGraphics, int x, int y, int columns, int rows) {
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                this.renderSlot(guiGraphics, x + column * 18, y + row * 18);
            }
        }
    }

    protected void renderPlayerInventoryAt(GuiGraphics guiGraphics, int x, int y, int inventoryStartY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Constants.TEXTURE_INVENTORY);
        guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, x + 7, y + inventoryStartY - 1, 7, 83, 162, 54);
        guiGraphics.m_280218_(Constants.TEXTURE_INVENTORY, x + 7, y + inventoryStartY + 57, 7, 141, 162, 18);
    }

    protected void renderProgressBar(GuiGraphics guiGraphics, int x, int y, int width, int height, int current, int max, int color) {
        guiGraphics.m_280509_(x, y, x + width, y + height, -11184811);
        if (max > 0 && current > 0) {
            int filledWidth = current * width / max;
            guiGraphics.m_280509_(x, y, x + filledWidth, y + height, 0xFF000000 | color);
        }
        guiGraphics.m_280509_(x, y, x + width, y + 1, -16777216);
        guiGraphics.m_280509_(x, y + height - 1, x + width, y + height, -16777216);
        guiGraphics.m_280509_(x, y, x + 1, y + height, -16777216);
        guiGraphics.m_280509_(x + width - 1, y, x + width, y + height, -16777216);
    }

    protected void renderEnergyPowerUI(GuiGraphics guiGraphics, int x, int y, int currentEnergy, int energyCapacity) {
        AbstractContainerMenu abstractContainerMenu = this.f_97732_;
        if (abstractContainerMenu instanceof EnergyPowerGeneratorMenu) {
            EnergyPowerGeneratorMenu generatorMenu = (EnergyPowerGeneratorMenu)abstractContainerMenu;
            EnergyPowerRenderer.renderEnergyPowerUI(guiGraphics, x, y, currentEnergy, energyCapacity, generatorMenu.getEnergyFlowStatus(), generatorMenu.getEnergyReceiveAmount(), generatorMenu.getEnergyDistributeAmount(), 6);
        } else {
            abstractContainerMenu = this.f_97732_;
            if (abstractContainerMenu instanceof EnergyPowerMenu) {
                EnergyPowerMenu energyPowerMenu = (EnergyPowerMenu)abstractContainerMenu;
                EnergyPowerRenderer.renderEnergyPowerUI(guiGraphics, x, y, currentEnergy, energyCapacity, energyPowerMenu.getEnergyFlowStatus(), energyPowerMenu.getEnergyReceiveAmount(), energyPowerMenu.getEnergyDistributeAmount(), 6);
            } else {
                EnergyPowerRenderer.renderEnergyPowerUI(guiGraphics, x, y, currentEnergy, energyCapacity, EnergyFlowStatus.IDLE, 0, 0, 6);
            }
        }
    }

    protected void renderEnergyPowerTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int leftPos, int topPos, int currentEnergy, int energyCapacity, String batteryTooltipKey, int batterySlotIndex) {
        EnergyPowerRenderer.renderEnergyPowerTooltips(guiGraphics, this.f_96547_, mouseX, mouseY, leftPos, topPos, currentEnergy, energyCapacity, batteryTooltipKey, this.f_97732_, batterySlotIndex);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        AbstractContainerMenu abstractContainerMenu = this.f_97732_;
        if (abstractContainerMenu instanceof EnergyPowerMenu) {
            EnergyPowerMenu energyPowerMenu = (EnergyPowerMenu)abstractContainerMenu;
            this.renderEnergyPowerUI(guiGraphics, this.f_97735_, this.f_97736_, energyPowerMenu.getCurrentEnergy(), energyPowerMenu.getEnergyCapacity());
        } else {
            abstractContainerMenu = this.f_97732_;
            if (abstractContainerMenu instanceof EnergyPowerGeneratorMenu) {
                EnergyPowerGeneratorMenu generatorMenu = (EnergyPowerGeneratorMenu)abstractContainerMenu;
                this.renderEnergyPowerUI(guiGraphics, this.f_97735_, this.f_97736_, generatorMenu.getEnergy(), generatorMenu.getEnergyCapacity());
            }
        }
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        AbstractContainerMenu abstractContainerMenu = this.f_97732_;
        if (abstractContainerMenu instanceof EnergyPowerMenu) {
            EnergyPowerMenu energyPowerMenu = (EnergyPowerMenu)abstractContainerMenu;
            this.renderEnergyPowerTooltips(guiGraphics, mouseX, mouseY, this.f_97735_, this.f_97736_, energyPowerMenu.getCurrentEnergy(), energyPowerMenu.getEnergyCapacity(), "gui.scrap_tech_workshop.battery_slot", energyPowerMenu.getBatterySlotIndex());
        } else {
            abstractContainerMenu = this.f_97732_;
            if (abstractContainerMenu instanceof EnergyPowerGeneratorMenu) {
                EnergyPowerGeneratorMenu generatorMenu = (EnergyPowerGeneratorMenu)abstractContainerMenu;
                this.renderEnergyPowerTooltips(guiGraphics, mouseX, mouseY, this.f_97735_, this.f_97736_, generatorMenu.getEnergy(), generatorMenu.getEnergyCapacity(), "gui.scrap_tech_workshop.battery_slot", generatorMenu.getBatterySlotIndex());
            }
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
    }
}

