/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.scraptechworkshop.client.screen.BaseContainerScreen;
import de.markusbordihn.scraptechworkshop.client.screen.energy.EnergyPowerRenderer;
import de.markusbordihn.scraptechworkshop.menu.ScrapMultitoolMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ScrapMultitoolScreen
extends BaseContainerScreen<ScrapMultitoolMenu> {
    private static final String TRANSLATION_KEY_PREFIX = "gui.scrap_tech_workshop.scrap_multitool.";
    private static final String TRANSLATION_BATTERY_SLOT = "gui.scrap_tech_workshop.scrap_multitool.battery_slot";
    private static final String TRANSLATION_MODULE_SLOTS = "gui.scrap_tech_workshop.scrap_multitool.module_slots";
    private static final int SCREEN_WIDTH = 176;
    private static final int SCREEN_HEIGHT = 220;
    private static final int TOOL_RENDER_X = 25;
    private static final int TOOL_RENDER_Y = 75;
    private static final float TOOL_RENDER_SCALE = 4.0f;
    private static final int ENERGY_BAR_X = 150;
    private static final int ENERGY_BAR_Y = 25;
    private static final int ENERGY_BAR_WIDTH = 16;
    private static final int ENERGY_BAR_HEIGHT = 80;
    private ItemRenderer itemRenderer;

    public ScrapMultitoolScreen(ScrapMultitoolMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 220;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        this.f_97729_ = 6;
        this.f_97731_ = this.f_97727_ - 94;
        Minecraft minecraft = Minecraft.m_91087_();
        this.itemRenderer = minecraft.m_91291_();
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.renderDefaultBackground(guiGraphics, x, y, this.f_97726_, this.f_97727_);
        this.renderSlot(guiGraphics, x + 85, y + 50);
        for (int i = 0; i < 4; ++i) {
            this.renderSlot(guiGraphics, x + 60 + i * 18, y + 95);
        }
        this.renderPlayerInventoryAt(guiGraphics, x, y, 138);
        this.render3DMultitool(guiGraphics, x, y);
        this.renderEnergyBar(guiGraphics, x, y);
    }

    private void render3DMultitool(GuiGraphics guiGraphics, int x, int y) {
        ItemStack multitoolStack = ((ScrapMultitoolMenu)this.f_97732_).getMultitoolStack();
        if (!multitoolStack.m_41619_()) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)(x + 25), (float)(y + 75), 100.0f);
            poseStack.m_85841_(64.0f, 64.0f, 64.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(60.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
            Minecraft minecraft = Minecraft.m_91087_();
            this.itemRenderer.m_269128_(multitoolStack, ItemDisplayContext.NONE, 0xF000F0, OverlayTexture.f_118083_, poseStack, (MultiBufferSource)guiGraphics.m_280091_(), (Level)minecraft.f_91073_, 0);
            guiGraphics.m_280262_();
            poseStack.m_85849_();
        }
    }

    private void renderEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        int energy = ((ScrapMultitoolMenu)this.f_97732_).getCurrentEnergyFromBattery();
        int maxEnergy = ((ScrapMultitoolMenu)this.f_97732_).getMaxEnergyFromBattery();
        EnergyPowerRenderer.renderEnergyBarWithFrame(guiGraphics, x + 150, y + 25, 16, 80, energy, maxEnergy);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void m_280072_(GuiGraphics guiGraphics, int x, int y) {
        super.m_280072_(guiGraphics, x, y);
        int relativeX = x - this.f_97735_;
        int relativeY = y - this.f_97736_;
        if (relativeX >= 150 && relativeX <= 166 && relativeY >= 25 && relativeY <= 105) {
            int currentEnergy = ((ScrapMultitoolMenu)this.f_97732_).getCurrentEnergyFromBattery();
            int maxEnergy = ((ScrapMultitoolMenu)this.f_97732_).getMaxEnergyFromBattery();
            int percentage = ((ScrapMultitoolMenu)this.f_97732_).getBatteryPercentageFromSlot();
            MutableComponent tooltip = Component.m_237110_((String)"gui.scrap_tech_workshop.scrap_multitool.energy_tooltip", (Object[])new Object[]{currentEnergy, maxEnergy, percentage});
            guiGraphics.m_280557_(this.f_96547_, (Component)tooltip, x, y);
        }
        if (relativeX >= 84 && relativeX <= 102 && relativeY >= 49 && relativeY <= 67 && ((ScrapMultitoolMenu)this.f_97732_).m_38853_(0).m_7993_().m_41619_()) {
            MutableComponent tooltip = Component.m_237115_((String)TRANSLATION_BATTERY_SLOT);
            guiGraphics.m_280557_(this.f_96547_, (Component)tooltip, x, y);
        }
        if (relativeX >= 60 && relativeX <= 133 && relativeY >= 94 && relativeY <= 112) {
            boolean allModuleSlotsEmpty = true;
            for (int i = 1; i <= 4; ++i) {
                if (((ScrapMultitoolMenu)this.f_97732_).m_38853_(i).m_7993_().m_41619_()) continue;
                allModuleSlotsEmpty = false;
                break;
            }
            if (allModuleSlotsEmpty) {
                MutableComponent tooltip = Component.m_237115_((String)TRANSLATION_MODULE_SLOTS);
                guiGraphics.m_280557_(this.f_96547_, (Component)tooltip, x, y);
            }
        }
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
        String energyText = ((ScrapMultitoolMenu)this.f_97732_).getBatteryPercentageFromSlot() + "%";
        int textWidth = this.f_96547_.m_92895_(energyText);
        guiGraphics.m_280056_(this.f_96547_, energyText, 150 + (16 - textWidth) / 2, 107, 0x404040, false);
    }
}

