/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.screen.recycler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.scraptechworkshop.client.screen.BaseContainerScreen;
import de.markusbordihn.scraptechworkshop.data.recycler.RecyclerStatus;
import de.markusbordihn.scraptechworkshop.menu.RecyclerMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RecyclerScreen
extends BaseContainerScreen<RecyclerMenu> {
    private static final String TRANSLATION_KEY_PREFIX = "gui.scrap_tech_workshop.recycler.";
    private static final String TRANSLATION_PROGRESS = "gui.scrap_tech_workshop.recycler.progress";
    private static final String TRANSLATION_NO_RECIPE = "gui.scrap_tech_workshop.recycler.no_recipe";
    private static final String TRANSLATION_DONE = "gui.scrap_tech_workshop.recycler.done";
    private static final String TRANSLATION_IDLE = "gui.scrap_tech_workshop.recycler.idle";
    private static final String TRANSLATION_INPUT_SLOT = "gui.scrap_tech_workshop.recycler.input_slot";
    private static final String TRANSLATION_OUTPUT_SLOTS = "gui.scrap_tech_workshop.recycler.output_slots";
    private static final String TRANSLATION_UPGRADE_SLOTS = "gui.scrap_tech_workshop.recycler.upgrade_slots";
    private static final int SCREEN_WIDTH = 176;
    private static final int SCREEN_HEIGHT = 205;
    private static final int INVENTORY_LABEL_OFFSET = 92;
    private static final int PROGRESS_ARROW_X = 80;
    private static final int PROGRESS_ARROW_Y = 35;
    private static final int PROGRESS_ARROW_HEIGHT = 16;
    private static final int PROGRESS_SCALE_FACTOR = 26;
    private static final int PROGRESS_AREA_X1 = 80;
    private static final int PROGRESS_AREA_X2 = 106;
    private static final int PROGRESS_AREA_Y1 = 35;
    private static final int PROGRESS_AREA_Y2 = 51;
    private static final int INPUT_SLOT_X = 26;
    private static final int INPUT_SLOT_Y = 35;
    private static final int OUTPUT_AREA_X = 116;
    private static final int OUTPUT_AREA_Y = 17;
    private static final int UPGRADE_SLOTS_X = 62;
    private static final int UPGRADE_SLOTS_Y = 71;
    private static final int BLOCK_RENDER_X = 53;
    private static final int BLOCK_RENDER_Y = 43;
    private static final float BLOCK_RENDER_SCALE = 12.0f;
    private BlockRenderDispatcher blockRenderer;
    private ItemRenderer itemRenderer;
    private float rotationAngle = 0.0f;

    public RecyclerScreen(RecyclerMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 205;
        this.f_97731_ = this.f_97727_ - 92;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        Minecraft minecraft = Minecraft.m_91087_();
        this.blockRenderer = minecraft.m_91289_();
        this.itemRenderer = minecraft.m_91291_();
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.renderDefaultBackground(guiGraphics, x, y, this.f_97726_, this.f_97727_);
        super.m_7286_(guiGraphics, partialTick, mouseX, mouseY);
        this.renderSlot(guiGraphics, x + 26, y + 35);
        this.renderSlots(guiGraphics, x + 116, y + 17, 3, 3);
        this.renderSlots(guiGraphics, x + 62, y + 71, 2, 1);
        this.renderPlayerInventoryAt(guiGraphics, x, y, 124);
        ItemStack inputItem = ((RecyclerMenu)this.f_97732_).getCurrentInput();
        if (!inputItem.m_41619_() && ((RecyclerMenu)this.f_97732_).isCrafting() && ((RecyclerMenu)this.f_97732_).getCurrentEnergy() > 0) {
            this.render3DBlock(guiGraphics, x, y, inputItem, partialTick);
        }
        int progress = ((RecyclerMenu)this.f_97732_).isCrafting() ? ((RecyclerMenu)this.f_97732_).getScaledProgress() : 0;
        int progressBarX = x + 80;
        int progressBarY = y + 35;
        int progressBarWidth = 26;
        int progressBarHeight = 16;
        guiGraphics.m_280509_(progressBarX, progressBarY, progressBarX + progressBarWidth, progressBarY + progressBarHeight, -11184811);
        if (progress > 0) {
            int filledWidth = progress * progressBarWidth / 26;
            guiGraphics.m_280509_(progressBarX, progressBarY, progressBarX + filledWidth, progressBarY + progressBarHeight, -16711936);
        }
    }

    private void render3DBlock(GuiGraphics guiGraphics, int x, int y, ItemStack inputItem, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(x + 53), (float)(y + 43), 100.0f);
        this.rotationAngle += partialTick * 2.0f;
        Item item = inputItem.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockState blockState = blockItem.m_40614_().m_49966_();
            poseStack.m_85841_(12.0f, -12.0f, 12.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(this.rotationAngle));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
            MultiBufferSource.BufferSource bufferSource = guiGraphics.m_280091_();
            this.blockRenderer.m_110912_(blockState, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_);
            bufferSource.m_109911_();
        } else {
            poseStack.m_85841_(18.0f, 18.0f, 18.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(this.rotationAngle));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
            this.itemRenderer.m_269128_(inputItem, ItemDisplayContext.GUI, 0xF000F0, OverlayTexture.f_118083_, poseStack, (MultiBufferSource)guiGraphics.m_280091_(), (Level)this.f_96541_.f_91073_, 0);
        }
        poseStack.m_85849_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void m_280072_(GuiGraphics guiGraphics, int x, int y) {
        super.m_280072_(guiGraphics, x, y);
        int relativeX = x - this.f_97735_;
        int relativeY = y - this.f_97736_;
        if (relativeX >= 80 && relativeX <= 106 && relativeY >= 35 && relativeY <= 51) {
            RecyclerStatus status = ((RecyclerMenu)this.f_97732_).getRecyclerStatus();
            if (((RecyclerMenu)this.f_97732_).isCrafting()) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237110_((String)TRANSLATION_PROGRESS, (Object[])new Object[]{((RecyclerMenu)this.f_97732_).getScaledProgress() * 100 / 26}), x, y);
            } else if (status == RecyclerStatus.NO_RECIPE) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)TRANSLATION_NO_RECIPE), x, y);
            } else if (status == RecyclerStatus.DONE) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)TRANSLATION_DONE), x, y);
            } else {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)TRANSLATION_IDLE), x, y);
            }
        }
        if (!((RecyclerMenu)this.f_97732_).isCrafting() && relativeX >= 25 && relativeX <= 43 && relativeY >= 34 && relativeY <= 52 && ((RecyclerMenu)this.f_97732_).m_38853_(0).m_7993_().m_41619_()) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)TRANSLATION_INPUT_SLOT), x, y);
        }
        if (relativeX >= 116 && relativeX <= 170 && relativeY >= 17 && relativeY <= 71) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)TRANSLATION_OUTPUT_SLOTS), x, y);
        }
        if (relativeX >= 62 && relativeX <= 98 && relativeY >= 71 && relativeY <= 89) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)TRANSLATION_UPGRADE_SLOTS), x, y);
        }
    }
}

