/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StrippableBlocks {
    private static final Map<Block, Block> STRIPPABLE_BLOCKS = new HashMap<Block, Block>();
    private static final Map<Block, Block> REVERSE_STRIPPABLE_BLOCKS = new HashMap<Block, Block>();

    public static Optional<BlockState> getStrippedState(BlockState state) {
        Block strippedBlock = STRIPPABLE_BLOCKS.get(state.m_60734_());
        if (strippedBlock != null) {
            return Optional.of((BlockState)strippedBlock.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_))));
        }
        return Optional.empty();
    }

    public static Optional<BlockState> getUnstrippedState(BlockState state) {
        Block unstrippedBlock = REVERSE_STRIPPABLE_BLOCKS.get(state.m_60734_());
        if (unstrippedBlock != null) {
            return Optional.of((BlockState)unstrippedBlock.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_))));
        }
        return Optional.empty();
    }

    public static boolean isStrippable(Block block) {
        return STRIPPABLE_BLOCKS.containsKey(block);
    }

    public static boolean isStripped(Block block) {
        return REVERSE_STRIPPABLE_BLOCKS.containsKey(block);
    }

    public static boolean isCycleableWood(Block block) {
        return StrippableBlocks.isStrippable(block) || StrippableBlocks.isStripped(block);
    }

    static {
        STRIPPABLE_BLOCKS.put(Blocks.f_49999_, Blocks.f_50010_);
        STRIPPABLE_BLOCKS.put(Blocks.f_50011_, Blocks.f_50044_);
        STRIPPABLE_BLOCKS.put(Blocks.f_50000_, Blocks.f_50005_);
        STRIPPABLE_BLOCKS.put(Blocks.f_50012_, Blocks.f_50045_);
        STRIPPABLE_BLOCKS.put(Blocks.f_50001_, Blocks.f_50006_);
        STRIPPABLE_BLOCKS.put(Blocks.f_50013_, Blocks.f_50046_);
        STRIPPABLE_BLOCKS.put(Blocks.f_50002_, Blocks.f_50007_);
        STRIPPABLE_BLOCKS.put(Blocks.f_50014_, Blocks.f_50047_);
        STRIPPABLE_BLOCKS.put(Blocks.f_50003_, Blocks.f_50008_);
        STRIPPABLE_BLOCKS.put(Blocks.f_50015_, Blocks.f_50048_);
        STRIPPABLE_BLOCKS.put(Blocks.f_50004_, Blocks.f_50009_);
        STRIPPABLE_BLOCKS.put(Blocks.f_50043_, Blocks.f_50049_);
        STRIPPABLE_BLOCKS.put(Blocks.f_220832_, Blocks.f_220835_);
        STRIPPABLE_BLOCKS.put(Blocks.f_220836_, Blocks.f_220837_);
        STRIPPABLE_BLOCKS.put(Blocks.f_271170_, Blocks.f_271326_);
        STRIPPABLE_BLOCKS.put(Blocks.f_271348_, Blocks.f_271145_);
        STRIPPABLE_BLOCKS.put(Blocks.f_50695_, Blocks.f_50696_);
        STRIPPABLE_BLOCKS.put(Blocks.f_50697_, Blocks.f_50698_);
        STRIPPABLE_BLOCKS.put(Blocks.f_50686_, Blocks.f_50687_);
        STRIPPABLE_BLOCKS.put(Blocks.f_50688_, Blocks.f_50689_);
        STRIPPABLE_BLOCKS.put(Blocks.f_256831_, Blocks.f_256740_);
        for (Map.Entry<Block, Block> entry : STRIPPABLE_BLOCKS.entrySet()) {
            REVERSE_STRIPPABLE_BLOCKS.put(entry.getValue(), entry.getKey());
        }
    }
}

