/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.energy;

import de.markusbordihn.scraptechworkshop.data.energy.EnergySourceType;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyStatus;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public record BatteryStatus(EnergyStatus status, EnergySourceType sourceType, boolean rechargeable, int cycleCount) {
    public static final String RECHARGEABLE_TAG = "Rechargeable";
    public static final String CYCLE_COUNT_TAG = "CycleCount";
    public static final String ENERGY_SOURCE_TAG = "EnergySource";
    public static final String ENERGY_STATUS_TAG = "EnergyStatus";

    public BatteryStatus(ItemStack itemStack) {
        this(BatteryStatus.readFromItemStack(itemStack));
    }

    private BatteryStatus(BatteryValues values) {
        this(values.status, values.sourceType, values.rechargeable, values.cycleCount);
    }

    private static BatteryValues readFromItemStack(ItemStack itemStack) {
        int cycleCount;
        boolean rechargeable;
        EnergySourceType sourceType;
        EnergyStatus status;
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            status = EnergyStatus.fromId(tag.m_128461_(ENERGY_STATUS_TAG));
            sourceType = EnergySourceType.fromId(tag.m_128461_(ENERGY_SOURCE_TAG));
            rechargeable = tag.m_128471_(RECHARGEABLE_TAG);
            cycleCount = tag.m_128451_(CYCLE_COUNT_TAG);
        } else {
            status = EnergyStatus.READY;
            sourceType = EnergySourceType.BATTERY;
            rechargeable = false;
            cycleCount = 0;
        }
        return new BatteryValues(status, sourceType, rechargeable, cycleCount);
    }

    public void writeToItemStack(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128359_(ENERGY_STATUS_TAG, this.status.getId());
        tag.m_128359_(ENERGY_SOURCE_TAG, this.sourceType.getId());
        tag.m_128379_(RECHARGEABLE_TAG, this.rechargeable);
        tag.m_128405_(CYCLE_COUNT_TAG, this.cycleCount);
    }

    public BatteryStatus withStatus(EnergyStatus newStatus) {
        return new BatteryStatus(newStatus, this.sourceType, this.rechargeable, this.cycleCount);
    }

    public BatteryStatus withCycleIncrement() {
        return new BatteryStatus(this.status, this.sourceType, this.rechargeable, this.cycleCount + 1);
    }

    public boolean canCharge() {
        return this.rechargeable && this.status != EnergyStatus.FAULTY && this.status != EnergyStatus.OVERCHARGED;
    }

    public boolean canDischarge() {
        return this.status != EnergyStatus.EMPTY && this.status != EnergyStatus.FAULTY;
    }

    public boolean isFaulty() {
        return this.status == EnergyStatus.FAULTY;
    }

    private record BatteryValues(EnergyStatus status, EnergySourceType sourceType, boolean rechargeable, int cycleCount) {
    }
}

