/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.energy;

public enum EnergySourceType {
    NONE("none"),
    BATTERY("battery"),
    BATTERY_BLOCK("battery_block"),
    PIPELINE("pipeline"),
    CABLE("cable"),
    EXTERNAL_MOD("external_mod");

    private final String id;

    private EnergySourceType(String id) {
        this.id = id;
    }

    public static EnergySourceType fromId(String id) {
        for (EnergySourceType type : EnergySourceType.values()) {
            if (!type.id.equals(id)) continue;
            return type;
        }
        return NONE;
    }

    public String getId() {
        return this.id;
    }

    public boolean isPortable() {
        return this == BATTERY;
    }

    public boolean isStationary() {
        return this == BATTERY_BLOCK || this == PIPELINE || this == CABLE;
    }

    public boolean isExternal() {
        return this == EXTERNAL_MOD;
    }
}

