/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.energy;

public enum EnergyStatus {
    EMPTY("empty"),
    DISCHARGING("discharging"),
    CHARGING("charging"),
    FULL("full"),
    FAULTY("faulty"),
    OVERCHARGED("overcharged"),
    READY("ready");

    private final String id;

    private EnergyStatus(String id) {
        this.id = id;
    }

    public static EnergyStatus fromId(String id) {
        for (EnergyStatus status : EnergyStatus.values()) {
            if (!status.id.equals(id)) continue;
            return status;
        }
        return READY;
    }

    public static EnergyStatus fromEnergyLevel(int current, int maximum) {
        if (current <= 0) {
            return EMPTY;
        }
        if (current >= maximum) {
            return FULL;
        }
        return READY;
    }

    public String getId() {
        return this.id;
    }
}

