/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.multitool;

import de.markusbordihn.scraptechworkshop.data.multitool.BatteryLevel;
import de.markusbordihn.scraptechworkshop.data.multitool.ToolMode;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record ScrapMultitoolData(ItemStack battery, ItemStack[] modules, int hologramColor, boolean hudEnabled, String toolPriority, String activeMode) {
    public static final int MODULE_SLOTS = 4;
    private static final String BATTERY_TAG = "Battery";
    private static final String MODULES_TAG = "Modules";
    private static final String HOLOGRAM_COLOR_TAG = "HologramColor";
    private static final String HUD_ENABLED_TAG = "HudEnabled";
    private static final String TOOL_PRIORITY_TAG = "ToolPriority";
    private static final String ACTIVE_MODE_TAG = "ActiveMode";
    private static final String MULTITOOL_DATA_TAG = "MultitoolData";

    public static ScrapMultitoolData createDefault() {
        return new ScrapMultitoolData(ItemStack.f_41583_, new ItemStack[4], 65535, true, "auto", ToolMode.DEFAULT.getId());
    }

    public static ScrapMultitoolData fromItemStack(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(MULTITOOL_DATA_TAG)) {
            return ScrapMultitoolData.fromNBT(compoundTag.m_128469_(MULTITOOL_DATA_TAG));
        }
        return ScrapMultitoolData.createDefault();
    }

    public static ScrapMultitoolData fromNBT(CompoundTag compoundTag) {
        ItemStack battery = ItemStack.f_41583_;
        if (compoundTag.m_128441_(BATTERY_TAG)) {
            battery = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_(BATTERY_TAG));
        }
        ItemStack[] modules = new ItemStack[4];
        if (compoundTag.m_128441_(MODULES_TAG)) {
            ListTag modulesTag = compoundTag.m_128437_(MODULES_TAG, 10);
            for (int i = 0; i < Math.min(modulesTag.size(), 4); ++i) {
                modules[i] = ItemStack.m_41712_((CompoundTag)modulesTag.m_128728_(i));
            }
        }
        return new ScrapMultitoolData(battery, modules, compoundTag.m_128451_(HOLOGRAM_COLOR_TAG), compoundTag.m_128471_(HUD_ENABLED_TAG), compoundTag.m_128461_(TOOL_PRIORITY_TAG), compoundTag.m_128441_(ACTIVE_MODE_TAG) ? compoundTag.m_128461_(ACTIVE_MODE_TAG) : ToolMode.DEFAULT.getId());
    }

    public boolean hasBattery() {
        return !this.battery.m_41619_();
    }

    public CompoundTag toNBT() {
        CompoundTag compoundTag = new CompoundTag();
        if (!this.battery.m_41619_()) {
            compoundTag.m_128365_(BATTERY_TAG, (Tag)this.battery.m_41739_(new CompoundTag()));
        }
        ListTag modulesTag = new ListTag();
        for (ItemStack module : this.modules) {
            if (module != null && !module.m_41619_()) {
                modulesTag.add((Object)module.m_41739_(new CompoundTag()));
                continue;
            }
            modulesTag.add((Object)new CompoundTag());
        }
        compoundTag.m_128365_(MODULES_TAG, (Tag)modulesTag);
        compoundTag.m_128405_(HOLOGRAM_COLOR_TAG, this.hologramColor);
        compoundTag.m_128379_(HUD_ENABLED_TAG, this.hudEnabled);
        compoundTag.m_128359_(TOOL_PRIORITY_TAG, this.toolPriority);
        compoundTag.m_128359_(ACTIVE_MODE_TAG, this.activeMode);
        return compoundTag;
    }

    public void saveToItemStack(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        compoundTag.m_128365_(MULTITOOL_DATA_TAG, (Tag)this.toNBT());
    }

    public ScrapMultitoolData withBattery(ItemStack newBattery) {
        return new ScrapMultitoolData(newBattery, this.modules, this.hologramColor, this.hudEnabled, this.toolPriority, this.activeMode);
    }

    public ScrapMultitoolData withModule(int slot, ItemStack module) {
        if (slot < 0 || slot >= 4) {
            return this;
        }
        ItemStack[] newModules = (ItemStack[])this.modules.clone();
        newModules[slot] = module;
        return new ScrapMultitoolData(this.battery, newModules, this.hologramColor, this.hudEnabled, this.toolPriority, this.activeMode);
    }

    public ScrapMultitoolData withActiveMode(String newMode) {
        return new ScrapMultitoolData(this.battery, this.modules, this.hologramColor, this.hudEnabled, this.toolPriority, newMode);
    }

    public BatteryLevel getBatteryLevel() {
        if (!this.hasBattery()) {
            return BatteryLevel.BATTERY_LEVEL_0;
        }
        Item item = this.battery.m_41720_();
        if (item instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)item;
            float percentage = batteryItem.getEnergyPercentage(this.battery);
            if (percentage >= 1.0f) {
                return BatteryLevel.BATTERY_LEVEL_100;
            }
            if (percentage >= 0.75f) {
                return BatteryLevel.BATTERY_LEVEL_75;
            }
            if (percentage >= 0.5f) {
                return BatteryLevel.BATTERY_LEVEL_50;
            }
            if (percentage >= 0.25f) {
                return BatteryLevel.BATTERY_LEVEL_25;
            }
        }
        return BatteryLevel.BATTERY_LEVEL_0;
    }
}

