/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.scrap;

import de.markusbordihn.scraptechworkshop.data.scrap.ScrapCategory;
import java.util.Locale;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.material.MapColor;

public enum ScrapType {
    ALLOY(ScrapCategory.MATERIAL, 20, Rarity.UNCOMMON, 1.2f, MapColor.f_283906_),
    COIL(ScrapCategory.MATERIAL, 12, Rarity.COMMON, 1.0f, MapColor.f_283906_),
    COPPER(ScrapCategory.MATERIAL, 12, Rarity.COMMON, 1.0f, MapColor.f_283750_),
    FASTENER(ScrapCategory.MATERIAL, 8, Rarity.COMMON, 1.0f, MapColor.f_283906_),
    GOLD(ScrapCategory.MATERIAL, 25, Rarity.UNCOMMON, 1.0f, MapColor.f_283757_),
    IRON(ScrapCategory.MATERIAL, 15, Rarity.COMMON, 1.0f, MapColor.f_283906_),
    METAL(ScrapCategory.MATERIAL, 10, Rarity.COMMON, 1.0f, MapColor.f_283906_),
    CRYSTAL(ScrapCategory.MINERAL, 20, Rarity.UNCOMMON, 1.3f, MapColor.f_283821_),
    MINERAL(ScrapCategory.MINERAL, 3, Rarity.COMMON, 0.5f, MapColor.f_283947_),
    BIO(ScrapCategory.ORGANIC, 3, Rarity.COMMON, 0.6f, MapColor.f_283915_),
    FIBER(ScrapCategory.ORGANIC, 4, Rarity.COMMON, 0.7f, MapColor.f_283930_),
    RUBBER(ScrapCategory.ORGANIC, 6, Rarity.COMMON, 0.8f, MapColor.f_283927_),
    WOOD(ScrapCategory.ORGANIC, 4, Rarity.COMMON, 0.7f, MapColor.f_283825_),
    CERAMIC(ScrapCategory.SYNTHETIC, 8, Rarity.COMMON, 0.8f, MapColor.f_283919_),
    GLASS(ScrapCategory.SYNTHETIC, 7, Rarity.COMMON, 0.9f, MapColor.f_283808_),
    INSULATION(ScrapCategory.SYNTHETIC, 8, Rarity.COMMON, 0.8f, MapColor.f_283744_),
    LUMINOUS(ScrapCategory.SYNTHETIC, 30, Rarity.RARE, 1.5f, MapColor.f_283869_, true),
    PLASTIC(ScrapCategory.SYNTHETIC, 5, Rarity.COMMON, 0.6f, MapColor.f_283772_),
    CAPACITOR(ScrapCategory.TECHNOLOGY, 15, Rarity.UNCOMMON, 1.2f, MapColor.f_283906_),
    CIRCUIT(ScrapCategory.TECHNOLOGY, 18, Rarity.UNCOMMON, 1.2f, MapColor.f_283906_),
    ENERGY_CELL(ScrapCategory.TECHNOLOGY, 25, Rarity.RARE, 1.5f, MapColor.f_283906_),
    TECH(ScrapCategory.TECHNOLOGY, 18, Rarity.UNCOMMON, 1.2f, MapColor.f_283906_);

    private final boolean luminous;
    private final float efficiencyBonus;
    private final int value;
    private final MapColor mapColor;
    private final Rarity rarity;
    private final ScrapCategory category;
    private final String blockName;
    private final String itemName;

    private ScrapType(ScrapCategory category, int value, Rarity rarity, float efficiencyBonus, MapColor mapColor) {
        this(category, value, rarity, efficiencyBonus, mapColor, false);
    }

    private ScrapType(ScrapCategory category, int value, Rarity rarity, float efficiencyBonus, MapColor mapColor, boolean luminous) {
        this.category = category;
        this.value = value;
        this.rarity = rarity;
        this.efficiencyBonus = efficiencyBonus;
        this.mapColor = mapColor;
        this.luminous = luminous;
        this.blockName = this.name().toLowerCase(Locale.ROOT) + "_scrap_box";
        this.itemName = this.name().toLowerCase(Locale.ROOT) + "_scrap";
    }

    public ScrapCategory getCategory() {
        return this.category;
    }

    public int getValue() {
        return this.value;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public float getEfficiencyBonus() {
        return this.efficiencyBonus;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    public boolean isLuminous() {
        return this.luminous;
    }

    public String getItemId() {
        return this.itemName;
    }

    public String getBlockId() {
        return this.blockName;
    }
}

