/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import net.minecraft.world.item.ItemStack;

public interface EnergyCell {
    public int getCapacity();

    public int getChargeRate();

    public int getDischargeRate();

    public ItemStack createEmptyBattery();

    default public int getEnergy(ItemStack itemStack) {
        if (itemStack.m_41773_() > this.getCapacity() - 1) {
            itemStack.m_41721_(this.getCapacity() - 1);
        }
        return Math.max(1, this.getCapacity() - itemStack.m_41773_());
    }

    default public void setEnergy(ItemStack itemStack, int energy) {
        itemStack.m_41721_(Math.min(this.getCapacity() - Math.max(1, Math.min(energy, this.getCapacity())), this.getCapacity() - 1));
    }

    default public void consumeEnergy(ItemStack itemStack, int amount) {
        this.setEnergy(itemStack, Math.max(1, this.getEnergy(itemStack) - amount));
    }

    default public boolean hasEnergy(ItemStack itemStack, int amount) {
        return this.getEnergy(itemStack) >= amount;
    }

    default public int addEnergy(ItemStack itemStack, int amount) {
        int currentEnergy = this.getEnergy(itemStack);
        int transferAmount = Math.min(amount, this.getChargeRate());
        int newEnergy = Math.min(this.getCapacity(), currentEnergy + transferAmount);
        this.setEnergy(itemStack, newEnergy);
        return newEnergy - currentEnergy;
    }

    default public int addEnergy(ItemStack itemStack) {
        return this.addEnergy(itemStack, this.getChargeRate());
    }

    default public int extractEnergy(ItemStack itemStack, int maxAmount) {
        int currentEnergy = this.getEnergy(itemStack);
        int amount = Math.min(maxAmount, Math.min(currentEnergy - 1, this.getDischargeRate()));
        if (amount > 0) {
            this.consumeEnergy(itemStack, amount);
        }
        return amount;
    }

    default public int extractEnergy(ItemStack itemStack) {
        return this.extractEnergy(itemStack, this.getDischargeRate());
    }

    default public float getEnergyPercentage(ItemStack itemStack) {
        return (float)this.getEnergy(itemStack) / (float)this.getCapacity();
    }

    default public int m_142159_(ItemStack itemStack) {
        float energyRatio = this.getEnergyPercentage(itemStack);
        return energyRatio > 0.6f ? 65280 : (energyRatio > 0.3f ? 0xFFFF00 : 0xFF0000);
    }
}

