/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.data.energy.BatteryStatus;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyData;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyCell;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class EnergyManager {
    private EnergyManager() {
    }

    public static EnergyData getEnergyData(ItemStack itemStack, int maxEnergy) {
        return new EnergyData(itemStack, maxEnergy);
    }

    public static BatteryStatus getBatteryStatus(ItemStack itemStack) {
        return new BatteryStatus(itemStack);
    }

    public static void setEnergy(ItemStack itemStack, int maxEnergy, int energy) {
        EnergyData energyData = new EnergyData(Math.max(1, Math.min(energy, maxEnergy)), maxEnergy, 100);
        energyData.writeToItemStack(itemStack);
        EnergyManager.updateBatteryStatus(itemStack, energyData);
    }

    private static void updateBatteryStatus(ItemStack itemStack, EnergyData energyData) {
        BatteryStatus currentStatus = EnergyManager.getBatteryStatus(itemStack);
        EnergyStatus newStatus = EnergyStatus.fromEnergyLevel(energyData.current(), energyData.maximum());
        if (currentStatus.status() != newStatus) {
            BatteryStatus updatedStatus = currentStatus.withStatus(newStatus);
            updatedStatus.writeToItemStack(itemStack);
        }
    }

    public static boolean hasEnergyFromBattery(ItemStack itemStack, int maxEnergy, ItemStack battery, int amount) {
        Item item = battery.m_41720_();
        if (!(item instanceof EnergyCellItem)) {
            return false;
        }
        EnergyCellItem batteryItem = (EnergyCellItem)item;
        return batteryItem.getEnergy(battery) >= amount;
    }

    public static void syncEnergyWithBattery(ItemStack itemStack, int maxEnergy, ItemStack battery) {
        Item item = battery.m_41720_();
        if (item instanceof EnergyCell) {
            EnergyCell cell = (EnergyCell)item;
            int batteryEnergy = cell.getEnergy(battery);
            if (batteryEnergy <= 1) {
                EnergyManager.setEnergy(itemStack, maxEnergy, 0);
                return;
            }
            float energyRatio = (float)batteryEnergy / (float)cell.getCapacity();
            int multitoolEnergy = Math.round((float)maxEnergy * energyRatio);
            EnergyManager.setEnergy(itemStack, maxEnergy, multitoolEnergy);
        } else {
            EnergyManager.setEnergy(itemStack, maxEnergy, 0);
        }
    }
}

