/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.data.energy.EnergyFlowStatus;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyPowerData;
import de.markusbordihn.scraptechworkshop.data.energy.ExternalEnergyFlowStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyCell;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerBatteryHandler;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.item.component.EmptyEnergyCellBlockItem;
import de.markusbordihn.scraptechworkshop.item.component.EmptyEnergyCellItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public interface EnergyPowerConsumer
extends EnergyPowerBatteryHandler {
    public static final String ENERGY_TAG = "Energy";
    public static final String BATTERY_TAG = "Battery";
    public static final String CHARGE_CYCLE_COUNT_TAG = "ChargeCycleCount";
    public static final String LAST_ENERGY_CHANGE_TIME_TAG = "LastEnergyChangeTime";
    public static final String LAST_ENERGY_LEVEL_TAG = "LastEnergyLevel";
    public static final String ENERGY_FLOW_STATUS_TAG = "EnergyFlowStatus";

    @Override
    public void markDirty();

    public EnergyPowerData getEnergyData();

    public void setEnergyData(EnergyPowerData var1);

    public int getLastEnergyReceiveAmount();

    public void setLastEnergyReceiveAmount(int var1);

    public int getLastEnergyDistributeAmount();

    public void setLastEnergyDistributeAmount(int var1);

    @Override
    default public int getCurrentEnergy() {
        return this.getEnergyData().currentEnergy();
    }

    @Override
    default public void setCurrentEnergy(int energy) {
        this.setEnergyData(this.getEnergyData().withCurrentEnergy(energy));
    }

    default public void resetEnergyFlowAmounts() {
        if (this.getLastEnergyReceiveAmount() != 0 || this.getLastEnergyDistributeAmount() != 0) {
            this.setLastEnergyReceiveAmount(0);
            this.setLastEnergyDistributeAmount(0);
        }
    }

    @Override
    default public ItemStack getBattery() {
        return this.getEnergyData().battery();
    }

    @Override
    default public void setBattery(ItemStack battery) {
        this.setEnergyData(this.getEnergyData().withBattery(battery));
    }

    @Override
    default public int getChargeCycleCount() {
        return this.getEnergyData().chargeCycleCount();
    }

    @Override
    default public void setChargeCycleCount(int count) {
        this.setEnergyData(this.getEnergyData().withChargeCycleCount(count));
    }

    @Override
    default public long getLastEnergyChangeTime() {
        return this.getEnergyData().lastEnergyChangeTime();
    }

    @Override
    default public void setLastEnergyChangeTime(long time) {
        this.setEnergyData(this.getEnergyData().withLastEnergyChangeTime(time));
    }

    @Override
    default public int getLastEnergyLevel() {
        return this.getEnergyData().lastEnergyLevel();
    }

    @Override
    default public void setLastEnergyLevel(int energy) {
        this.setEnergyData(this.getEnergyData().withLastEnergyLevel(energy));
    }

    @Override
    default public EnergyFlowStatus getEnergyFlowStatus() {
        return this.getEnergyData().energyFlowStatus();
    }

    @Override
    default public void setEnergyFlowStatus(EnergyFlowStatus status) {
        this.setEnergyData(this.getEnergyData().withEnergyFlowStatus(status));
    }

    default public ExternalEnergyFlowStatus getExternalEnergyFlowStatus() {
        return this.getEnergyData().externalEnergyFlowStatus();
    }

    default public void setExternalEnergyFlowStatus(ExternalEnergyFlowStatus status) {
        this.setEnergyData(this.getEnergyData().withExternalEnergyFlowStatus(status));
    }

    default public ContainerData createEnergyContainerData() {
        return new ContainerData(){
            private int lastReceiveAmount = 0;
            private int lastDistributeAmount = 0;

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> EnergyPowerConsumer.this.getCurrentEnergy();
                    case 1 -> EnergyPowerConsumer.this.getEnergyCapacity();
                    case 2 -> EnergyPowerConsumer.this.getEnergyFlowStatus().ordinal();
                    case 3 -> EnergyPowerConsumer.this.getExternalEnergyFlowStatus().ordinal();
                    case 4 -> this.lastReceiveAmount;
                    case 5 -> this.lastDistributeAmount;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        EnergyPowerConsumer.this.setCurrentEnergy(value);
                        break;
                    }
                    case 2: {
                        EnergyFlowStatus[] statuses = EnergyFlowStatus.values();
                        if (value < 0 || value >= statuses.length) break;
                        EnergyPowerConsumer.this.setEnergyFlowStatus(statuses[value]);
                        break;
                    }
                    case 3: {
                        ExternalEnergyFlowStatus[] statuses = ExternalEnergyFlowStatus.values();
                        if (value < 0 || value >= statuses.length) break;
                        EnergyPowerConsumer.this.setExternalEnergyFlowStatus(statuses[value]);
                        break;
                    }
                    case 4: {
                        this.lastReceiveAmount = value;
                        break;
                    }
                    case 5: {
                        this.lastDistributeAmount = value;
                    }
                }
            }

            public int m_6499_() {
                return 6;
            }
        };
    }

    public ContainerData getEnergyPowerData();

    default public boolean consumeEnergy(int amount) {
        if (this.getCurrentEnergy() >= amount) {
            this.setCurrentEnergy(this.getCurrentEnergy() - amount);
            return true;
        }
        return false;
    }

    default public boolean canAcceptExternalEnergy() {
        if (this.getCurrentEnergy() < this.getEnergyCapacity()) {
            return true;
        }
        ItemStack battery = this.getBattery();
        if (battery.m_41720_() instanceof EmptyEnergyCellItem || battery.m_41720_() instanceof EmptyEnergyCellBlockItem) {
            return true;
        }
        Item item = battery.m_41720_();
        if (item instanceof EnergyCell) {
            EnergyCell cell = (EnergyCell)item;
            return cell.getEnergy(battery) < cell.getCapacity();
        }
        return false;
    }

    default public int getTotalSpaceAvailable() {
        int internalSpace = this.getEnergyCapacity() - this.getCurrentEnergy();
        ItemStack battery = this.getBattery();
        if (battery.m_41720_() instanceof EmptyEnergyCellItem || battery.m_41720_() instanceof EmptyEnergyCellBlockItem) {
            return internalSpace + Math.min(10000, 150);
        }
        Item item = battery.m_41720_();
        if (item instanceof EnergyCell) {
            EnergyCell cell = (EnergyCell)item;
            return internalSpace + Math.min(cell.getCapacity() - cell.getEnergy(battery), cell.getChargeRate());
        }
        return internalSpace;
    }

    default public int receiveEnergy(int amount, boolean simulate) {
        int spaceInInternal = this.getEnergyCapacity() - this.getCurrentEnergy();
        if (spaceInInternal >= amount) {
            if (!simulate) {
                this.setCurrentEnergy(this.getCurrentEnergy() + amount);
                this.setLastEnergyReceiveAmount(amount);
                if (amount > 0) {
                    this.setExternalEnergyFlowStatus(ExternalEnergyFlowStatus.ENERGY_IN);
                }
            }
            return amount;
        }
        int overflow = amount - spaceInInternal;
        int toBattery = 0;
        ItemStack battery = this.getBattery();
        if (battery.m_41720_() instanceof EmptyEnergyCellItem || battery.m_41720_() instanceof EmptyEnergyCellBlockItem) {
            ItemStack chargedBattery;
            Item item;
            toBattery = Math.min(overflow, 150);
            if (!simulate && (item = (chargedBattery = battery.m_41720_() instanceof EmptyEnergyCellBlockItem ? new ItemStack((ItemLike)ModItems.ENERGY_CELL_BLOCK.get()) : new ItemStack((ItemLike)ModItems.ENERGY_CELL.get())).m_41720_()) instanceof EnergyCell) {
                EnergyCell energyCell = (EnergyCell)item;
                energyCell.setEnergy(chargedBattery, toBattery);
                this.setBattery(chargedBattery);
            }
        } else {
            Item item = battery.m_41720_();
            if (item instanceof EnergyCell) {
                EnergyCell cell = (EnergyCell)item;
                toBattery = Math.min(overflow, Math.min(cell.getCapacity() - cell.getEnergy(battery), cell.getChargeRate()));
                if (!simulate && toBattery > 0) {
                    cell.addEnergy(battery, toBattery);
                    this.setBattery(battery);
                }
            }
        }
        int totalReceived = spaceInInternal + toBattery;
        if (!simulate) {
            if (spaceInInternal > 0) {
                this.setCurrentEnergy(this.getCurrentEnergy() + spaceInInternal);
            }
            this.setLastEnergyReceiveAmount(totalReceived);
            if (totalReceived > 0) {
                this.setExternalEnergyFlowStatus(ExternalEnergyFlowStatus.ENERGY_IN);
            }
        }
        return totalReceived;
    }

    default public boolean hasStableEnergy(int requiredEnergy) {
        return this.hasStableEnergy(requiredEnergy, 10);
    }

    default public boolean hasStableEnergy(int requiredEnergy, int threshold) {
        int currentEnergy = this.getCurrentEnergy();
        return currentEnergy >= requiredEnergy && currentEnergy >= requiredEnergy + threshold;
    }

    default public void loadEnergyPowerConsumer(CompoundTag compoundTag) {
        int energy = compoundTag.m_128451_(ENERGY_TAG);
        ItemStack battery = compoundTag.m_128441_(BATTERY_TAG) ? ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_(BATTERY_TAG)) : ItemStack.f_41583_;
        int chargeCycleCount = compoundTag.m_128451_(CHARGE_CYCLE_COUNT_TAG);
        long lastEnergyChangeTime = compoundTag.m_128454_(LAST_ENERGY_CHANGE_TIME_TAG);
        int lastEnergyLevel = compoundTag.m_128451_(LAST_ENERGY_LEVEL_TAG);
        EnergyFlowStatus flowStatus = EnergyFlowStatus.values()[Math.max(0, Math.min(compoundTag.m_128451_(ENERGY_FLOW_STATUS_TAG), EnergyFlowStatus.values().length - 1))];
        ExternalEnergyFlowStatus externalFlowStatus = ExternalEnergyFlowStatus.IDLE;
        this.setEnergyData(new EnergyPowerData(energy, battery, chargeCycleCount, lastEnergyChangeTime, lastEnergyLevel, flowStatus, externalFlowStatus));
    }

    default public void saveEnergyPowerConsumer(CompoundTag compoundTag) {
        EnergyPowerData data = this.getEnergyData();
        compoundTag.m_128405_(ENERGY_TAG, data.currentEnergy());
        if (!data.battery().m_41619_()) {
            CompoundTag batteryTag = new CompoundTag();
            data.battery().m_41739_(batteryTag);
            compoundTag.m_128365_(BATTERY_TAG, (Tag)batteryTag);
        }
        compoundTag.m_128405_(CHARGE_CYCLE_COUNT_TAG, data.chargeCycleCount());
        compoundTag.m_128356_(LAST_ENERGY_CHANGE_TIME_TAG, data.lastEnergyChangeTime());
        compoundTag.m_128405_(LAST_ENERGY_LEVEL_TAG, data.lastEnergyLevel());
        compoundTag.m_128405_(ENERGY_FLOW_STATUS_TAG, data.energyFlowStatus().ordinal());
    }
}

