/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.data.energy.EnergyFlowStatus;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyPowerData;
import de.markusbordihn.scraptechworkshop.data.energy.ExternalEnergyFlowStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyBatteryHandler;
import de.markusbordihn.scraptechworkshop.energy.EnergyCell;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerBatteryHandler;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerConsumer;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.item.component.EmptyEnergyCellBlockItem;
import de.markusbordihn.scraptechworkshop.item.component.EmptyEnergyCellItem;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface EnergyPowerGenerator
extends EnergyBatteryHandler {
    public static final String ENERGY_TAG = "Energy";
    public static final String BATTERY_TAG = "Battery";
    public static final int TICKS_PER_SECOND = 20;

    @Override
    public int getEnergyCapacity();

    @Override
    public void markDirty();

    public EnergyPowerData getEnergyData();

    public void setEnergyData(EnergyPowerData var1);

    public int getLastEnergyReceiveAmount();

    public void setLastEnergyReceiveAmount(int var1);

    public int getLastEnergyDistributeAmount();

    public void setLastEnergyDistributeAmount(int var1);

    @Override
    default public int getCurrentEnergy() {
        return this.getEnergyData().currentEnergy();
    }

    @Override
    default public void setCurrentEnergy(int energy) {
        this.setEnergyData(this.getEnergyData().withCurrentEnergy(energy));
    }

    @Override
    default public ItemStack getBattery() {
        return this.getEnergyData().battery();
    }

    @Override
    default public void setBattery(ItemStack battery) {
        this.setEnergyData(this.getEnergyData().withBattery(battery));
    }

    default public ExternalEnergyFlowStatus getExternalEnergyFlowStatus() {
        return this.getEnergyData().externalEnergyFlowStatus();
    }

    default public void setExternalEnergyFlowStatus(ExternalEnergyFlowStatus status) {
        this.setEnergyData(this.getEnergyData().withExternalEnergyFlowStatus(status));
    }

    default public void resetEnergyFlowAmounts() {
        if (this.getLastEnergyReceiveAmount() != 0 || this.getLastEnergyDistributeAmount() != 0) {
            this.setLastEnergyReceiveAmount(0);
            this.setLastEnergyDistributeAmount(0);
        }
    }

    default public int getEnergyTransferRate() {
        return 50;
    }

    default public ContainerData createEnergyContainerData() {
        return new ContainerData(){
            private int lastReceiveAmount = 0;
            private int lastDistributeAmount = 0;

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> EnergyPowerGenerator.this.getCurrentEnergy();
                    case 1 -> EnergyPowerGenerator.this.getEnergyCapacity();
                    case 2 -> {
                        EnergyPowerGenerator var3_2 = EnergyPowerGenerator.this;
                        if (var3_2 instanceof EnergyPowerBatteryHandler) {
                            EnergyPowerBatteryHandler handler = (EnergyPowerBatteryHandler)((Object)var3_2);
                            yield handler.getEnergyFlowStatus().ordinal();
                        }
                        yield 0;
                    }
                    case 3 -> EnergyPowerGenerator.this.getEnergyData().externalEnergyFlowStatus().ordinal();
                    case 4 -> this.lastReceiveAmount;
                    case 5 -> this.lastDistributeAmount;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        EnergyPowerGenerator.this.setCurrentEnergy(value);
                        break;
                    }
                    case 2: {
                        EnergyPowerGenerator energyPowerGenerator = EnergyPowerGenerator.this;
                        if (!(energyPowerGenerator instanceof EnergyPowerBatteryHandler)) break;
                        EnergyPowerBatteryHandler handler = (EnergyPowerBatteryHandler)((Object)energyPowerGenerator);
                        EnergyFlowStatus[] statuses = EnergyFlowStatus.values();
                        if (value < 0 || value >= statuses.length) break;
                        handler.setEnergyFlowStatus(statuses[value]);
                        break;
                    }
                    case 3: {
                        ExternalEnergyFlowStatus[] statuses = ExternalEnergyFlowStatus.values();
                        if (value < 0 || value >= statuses.length) break;
                        EnergyPowerGenerator.this.setEnergyData(EnergyPowerGenerator.this.getEnergyData().withExternalEnergyFlowStatus(statuses[value]));
                        break;
                    }
                    case 4: {
                        this.lastReceiveAmount = value;
                        break;
                    }
                    case 5: {
                        this.lastDistributeAmount = value;
                    }
                }
            }

            public int m_6499_() {
                return 6;
            }
        };
    }

    public ContainerData getEnergyPowerData();

    default public int getAdaptiveTransferRate(int baseTransferRate) {
        if (this.getCurrentEnergy() > baseTransferRate) {
            return baseTransferRate;
        }
        return Math.max(1, baseTransferRate / 20);
    }

    default public boolean generateEnergy(int amount) {
        int energyToAdd = Math.min(amount, this.getEnergyCapacity() - this.getCurrentEnergy());
        if (energyToAdd > 0) {
            this.setCurrentEnergy(this.getCurrentEnergy() + energyToAdd);
            return true;
        }
        return false;
    }

    default public int extractEnergy(int amount, boolean simulate) {
        int energyExtracted = Math.min(amount, this.getCurrentEnergy());
        if (!simulate && energyExtracted > 0) {
            this.setCurrentEnergy(this.getCurrentEnergy() - energyExtracted);
        }
        return energyExtracted;
    }

    default public void loadEnergyPowerGenerator(CompoundTag compoundTag) {
        int energy = compoundTag.m_128451_(ENERGY_TAG);
        ItemStack battery = ItemStack.f_41583_;
        if (compoundTag.m_128441_(BATTERY_TAG)) {
            battery = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_(BATTERY_TAG));
        }
        EnergyPowerData data = EnergyPowerData.withEnergy(energy).withBattery(battery);
        if (this instanceof EnergyPowerBatteryHandler) {
            if (compoundTag.m_128441_("ChargeCycleCount")) {
                data = data.withChargeCycleCount(compoundTag.m_128451_("ChargeCycleCount"));
            }
            if (compoundTag.m_128441_("LastEnergyChangeTime")) {
                data = data.withLastEnergyChangeTime(compoundTag.m_128454_("LastEnergyChangeTime"));
            }
            if (compoundTag.m_128441_("LastEnergyLevel")) {
                data = data.withLastEnergyLevel(compoundTag.m_128451_("LastEnergyLevel"));
            }
            if (compoundTag.m_128441_("EnergyFlowStatus")) {
                int statusOrdinal = compoundTag.m_128451_("EnergyFlowStatus");
                EnergyFlowStatus[] statuses = EnergyFlowStatus.values();
                if (statusOrdinal >= 0 && statusOrdinal < statuses.length) {
                    data = data.withEnergyFlowStatus(statuses[statusOrdinal]);
                }
            }
        }
        this.setEnergyData(data);
    }

    default public void saveEnergyPowerGenerator(CompoundTag compoundTag) {
        EnergyPowerData data = this.getEnergyData();
        compoundTag.m_128405_(ENERGY_TAG, data.currentEnergy());
        if (!data.battery().m_41619_()) {
            CompoundTag batteryTag = new CompoundTag();
            data.battery().m_41739_(batteryTag);
            compoundTag.m_128365_(BATTERY_TAG, (Tag)batteryTag);
        }
        if (this instanceof EnergyPowerBatteryHandler) {
            compoundTag.m_128405_("ChargeCycleCount", data.chargeCycleCount());
            compoundTag.m_128356_("LastEnergyChangeTime", data.lastEnergyChangeTime());
            compoundTag.m_128405_("LastEnergyLevel", data.lastEnergyLevel());
            compoundTag.m_128405_("EnergyFlowStatus", data.energyFlowStatus().ordinal());
        }
    }

    default public int distributeToPlatformEnergySystem(Level level, BlockPos blockPos, int availableEnergy, int maxTransferRate) {
        try {
            Class<?> distributorClass = Class.forName("de.markusbordihn.scraptechworkshop.energy.compat.EnergyDistributor");
            Method method = distributorClass.getMethod("distributeToAdjacentBlocks", Level.class, BlockPos.class, Integer.TYPE, Integer.TYPE);
            Object result = method.invoke(null, level, blockPos, availableEnergy, maxTransferRate);
            return (Integer)result;
        }
        catch (Exception e) {
            return 0;
        }
    }

    default public int distributeEnergy(Level level, BlockPos blockPos, int chargingBatterySlot, int maxTransferRate) {
        EnergyPowerGenerator energyPowerGenerator;
        Container container;
        ItemStack battery;
        int batterySpace;
        EnergyPowerGenerator energyPowerGenerator2;
        if (level == null || level.f_46443_) {
            return 0;
        }
        int availableEnergy = this.getCurrentEnergy();
        if (availableEnergy <= 0) {
            return 0;
        }
        int totalDistributed = 0;
        int platformDistributed = this.distributeToPlatformEnergySystem(level, blockPos, availableEnergy, maxTransferRate);
        if (platformDistributed > 0) {
            this.extractEnergy(platformDistributed, false);
            totalDistributed += platformDistributed;
            availableEnergy -= platformDistributed;
            this.markDirty();
        }
        ArrayList<EnergyConsumerInfo> consumers = new ArrayList<EnergyConsumerInfo>();
        for (Direction direction : Direction.values()) {
            int spaceAvailable;
            EnergyPowerConsumer consumer;
            BlockPos adjacentPos = blockPos.m_121945_(direction);
            BlockEntity blockEntity = level.m_7702_(adjacentPos);
            if (!(blockEntity instanceof EnergyPowerConsumer) || !(consumer = (EnergyPowerConsumer)blockEntity).canAcceptExternalEnergy() || (spaceAvailable = consumer.getTotalSpaceAvailable()) <= 0) continue;
            consumers.add(new EnergyConsumerInfo(consumer, spaceAvailable));
        }
        if (chargingBatterySlot >= 0 && (energyPowerGenerator2 = this) instanceof Container && (batterySpace = this.getBatterySpaceAvailable(battery = (container = (Container)energyPowerGenerator2).m_8020_(chargingBatterySlot))) > 0) {
            consumers.add(new EnergyConsumerInfo(container, chargingBatterySlot, battery, batterySpace));
        }
        if (!consumers.isEmpty()) {
            int totalSpace = consumers.stream().mapToInt(c -> c.spaceAvailable).sum();
            int energyToDistribute = Math.min(Math.min(availableEnergy, maxTransferRate), totalSpace);
            if (energyToDistribute > 0) {
                int remainingEnergy = energyToDistribute;
                for (int i = 0; i < consumers.size(); ++i) {
                    int energyForThis;
                    EnergyConsumerInfo consumer = (EnergyConsumerInfo)consumers.get(i);
                    if (i == consumers.size() - 1) {
                        energyForThis = Math.min(remainingEnergy, consumer.spaceAvailable);
                    } else {
                        energyForThis = Math.min(energyToDistribute * consumer.spaceAvailable / totalSpace, consumer.spaceAvailable);
                        energyForThis = Math.min(energyForThis, remainingEnergy);
                    }
                    if (energyForThis <= 0) continue;
                    int actualTransferred = consumer.receiveEnergy(energyForThis);
                    totalDistributed += actualTransferred;
                    remainingEnergy -= actualTransferred;
                }
                if (totalDistributed > platformDistributed) {
                    this.extractEnergy(totalDistributed - platformDistributed, false);
                    this.markDirty();
                }
            }
        }
        if ((energyPowerGenerator = this) instanceof EnergyPowerBatteryHandler) {
            EnergyPowerBatteryHandler batteryHandler = (EnergyPowerBatteryHandler)((Object)energyPowerGenerator);
            this.chargeEnergyTabBattery(batteryHandler);
        }
        this.setLastEnergyDistributeAmount(totalDistributed);
        if (totalDistributed > 0) {
            this.setExternalEnergyFlowStatus(ExternalEnergyFlowStatus.ENERGY_OUT);
            this.markDirty();
        }
        return totalDistributed;
    }

    default public void chargeEnergyTabBattery(EnergyPowerBatteryHandler handler) {
        EnergyCell cell;
        int batteryEnergy;
        ItemStack battery = handler.getBattery();
        if (battery.m_41619_()) {
            return;
        }
        int capacity = this.getEnergyCapacity();
        if (battery.m_41720_() instanceof EmptyEnergyCellBlockItem) {
            ItemStack chargedBattery;
            Item item;
            if (this.getCurrentEnergy() >= capacity && (item = (chargedBattery = new ItemStack((ItemLike)ModItems.ENERGY_CELL_BLOCK.get())).m_41720_()) instanceof EnergyCell) {
                EnergyCell energyCell = (EnergyCell)item;
                int energyToAdd = Math.min(this.getCurrentEnergy() - capacity + 1, energyCell.getCapacity());
                energyCell.setEnergy(chargedBattery, energyToAdd);
                handler.setBattery(chargedBattery);
                this.setCurrentEnergy(this.getCurrentEnergy() - energyToAdd);
                this.markDirty();
            }
            return;
        }
        if (battery.m_41720_() instanceof EmptyEnergyCellItem) {
            ItemStack chargedBattery;
            Item energyToAdd;
            if (this.getCurrentEnergy() >= capacity && (energyToAdd = (chargedBattery = new ItemStack((ItemLike)ModItems.ENERGY_CELL.get())).m_41720_()) instanceof EnergyCell) {
                EnergyCell energyCell = (EnergyCell)energyToAdd;
                int energyToAdd2 = Math.min(this.getCurrentEnergy() - capacity + 1, energyCell.getCapacity());
                energyCell.setEnergy(chargedBattery, energyToAdd2);
                handler.setBattery(chargedBattery);
                this.setCurrentEnergy(this.getCurrentEnergy() - energyToAdd2);
                this.markDirty();
            }
            return;
        }
        Item energyCell = battery.m_41720_();
        if (energyCell instanceof EnergyCell && (batteryEnergy = (cell = (EnergyCell)energyCell).getEnergy(battery)) < cell.getCapacity()) {
            int transferred;
            int targetEnergy = capacity * handler.getChargingMode().getTargetPercentage() / 100;
            if (this.getCurrentEnergy() > targetEnergy && (transferred = cell.addEnergy(battery, this.getCurrentEnergy() - targetEnergy)) > 0) {
                this.setCurrentEnergy(this.getCurrentEnergy() - transferred);
                handler.setBattery(battery);
                this.markDirty();
            }
        }
    }

    default public int getBatterySpaceAvailable(ItemStack battery) {
        if (battery.m_41619_()) {
            return 0;
        }
        if (battery.m_41720_() instanceof EmptyEnergyCellBlockItem) {
            ItemStack tempCell = new ItemStack((ItemLike)ModItems.ENERGY_CELL_BLOCK.get());
            Item item = tempCell.m_41720_();
            if (item instanceof EnergyCell) {
                EnergyCell cell = (EnergyCell)item;
                return cell.getCapacity();
            }
            return 10000;
        }
        if (battery.m_41720_() instanceof EmptyEnergyCellItem) {
            ItemStack tempCell = new ItemStack((ItemLike)ModItems.ENERGY_CELL.get());
            Item item = tempCell.m_41720_();
            if (item instanceof EnergyCell) {
                EnergyCell cell = (EnergyCell)item;
                return cell.getCapacity();
            }
            return 5000;
        }
        Item cell = battery.m_41720_();
        if (cell instanceof EnergyCell) {
            EnergyCell cell2 = (EnergyCell)cell;
            int currentEnergy = cell2.getEnergy(battery);
            return cell2.getCapacity() - currentEnergy;
        }
        return 0;
    }

    public static class EnergyConsumerInfo {
        private final EnergyPowerConsumer blockConsumer;
        private final Container batteryContainer;
        private final int batterySlot;
        private final ItemStack battery;
        private final int spaceAvailable;

        public EnergyConsumerInfo(EnergyPowerConsumer consumer, int spaceAvailable) {
            this.blockConsumer = consumer;
            this.batteryContainer = null;
            this.batterySlot = -1;
            this.battery = null;
            this.spaceAvailable = spaceAvailable;
        }

        public EnergyConsumerInfo(Container container, int slot, ItemStack battery, int spaceAvailable) {
            this.blockConsumer = null;
            this.batteryContainer = container;
            this.batterySlot = slot;
            this.battery = battery;
            this.spaceAvailable = spaceAvailable;
        }

        public int receiveEnergy(int amount) {
            if (this.blockConsumer != null) {
                return this.blockConsumer.receiveEnergy(amount, false);
            }
            if (this.battery != null && this.batteryContainer != null) {
                return this.chargeBatteryItem(this.batteryContainer, this.batterySlot, this.battery, amount);
            }
            return 0;
        }

        private int chargeBatteryItem(Container container, int slot, ItemStack battery, int amount) {
            if (battery.m_41720_() instanceof EmptyEnergyCellBlockItem) {
                ItemStack chargedBattery = new ItemStack((ItemLike)ModItems.ENERGY_CELL_BLOCK.get());
                Item item = chargedBattery.m_41720_();
                if (item instanceof EnergyCell) {
                    EnergyCell energyCell = (EnergyCell)item;
                    int energyToAdd = Math.min(amount, energyCell.getCapacity());
                    energyCell.setEnergy(chargedBattery, energyToAdd);
                    container.m_6836_(slot, chargedBattery);
                    return energyToAdd;
                }
            } else if (battery.m_41720_() instanceof EmptyEnergyCellItem) {
                ItemStack chargedBattery = new ItemStack((ItemLike)ModItems.ENERGY_CELL.get());
                Item energyToAdd = chargedBattery.m_41720_();
                if (energyToAdd instanceof EnergyCell) {
                    EnergyCell energyCell = (EnergyCell)energyToAdd;
                    int energyToAdd2 = Math.min(amount, energyCell.getCapacity());
                    energyCell.setEnergy(chargedBattery, energyToAdd2);
                    container.m_6836_(slot, chargedBattery);
                    return energyToAdd2;
                }
            } else {
                Item chargedBattery = battery.m_41720_();
                if (chargedBattery instanceof EnergyCell) {
                    EnergyCell cell = (EnergyCell)chargedBattery;
                    int energyToAdd = Math.min(amount, cell.getCapacity() - cell.getEnergy(battery));
                    cell.setEnergy(battery, cell.getEnergy(battery) + energyToAdd);
                    return energyToAdd;
                }
            }
            return 0;
        }
    }
}

