/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy.compat;

import de.markusbordihn.scraptechworkshop.energy.EnergyPowerConsumer;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerGenerator;
import de.markusbordihn.scraptechworkshop.energy.compat.ForgeEnergyGeneratorWrapper;
import de.markusbordihn.scraptechworkshop.energy.compat.ForgeEnergyWrapper;
import de.markusbordihn.scraptechworkshop.energy.compat.MekanismEnergyGeneratorWrapper;
import java.lang.reflect.Field;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="scrap_tech_workshop")
public class EnergyCapabilityHandler {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");

    @SubscribeEvent
    public static void attachBlockEntityCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        BlockEntity blockEntity = (BlockEntity)event.getObject();
        if (blockEntity instanceof EnergyPowerGenerator) {
            EnergyPowerGenerator energyGenerator = (EnergyPowerGenerator)blockEntity;
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"scrap_tech_workshop", (String)"forge_energy"), (ICapabilityProvider)new ForgeEnergyGeneratorCapabilityProvider(energyGenerator));
            if (MekanismEnergyGeneratorWrapper.initialize()) {
                event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"scrap_tech_workshop", (String)"mekanism_energy"), (ICapabilityProvider)new MekanismEnergyGeneratorCapabilityProvider(energyGenerator));
                log.debug("Attached Mekanism Energy Generator capability to {}", (Object)blockEntity.getClass().getSimpleName());
            }
            log.debug("Attached Forge Energy Generator capability to {}", (Object)blockEntity.getClass().getSimpleName());
        } else if (blockEntity instanceof EnergyPowerConsumer) {
            EnergyPowerConsumer energyConsumer = (EnergyPowerConsumer)blockEntity;
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"scrap_tech_workshop", (String)"forge_energy"), (ICapabilityProvider)new ForgeEnergyConsumerCapabilityProvider(energyConsumer));
            log.debug("Attached Forge Energy Consumer capability to {}", (Object)blockEntity.getClass().getSimpleName());
        }
    }

    private static class ForgeEnergyGeneratorCapabilityProvider
    implements ICapabilityProvider {
        private final LazyOptional<ForgeEnergyGeneratorWrapper> forgeEnergyOptional = LazyOptional.of(() -> new ForgeEnergyGeneratorWrapper(energyGenerator));

        public ForgeEnergyGeneratorCapabilityProvider(EnergyPowerGenerator energyGenerator) {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
            if (capability == ForgeCapabilities.ENERGY) {
                return this.forgeEnergyOptional.cast();
            }
            return LazyOptional.empty();
        }
    }

    private static class MekanismEnergyGeneratorCapabilityProvider
    implements ICapabilityProvider {
        private final Object mekanismProxy;
        private final Capability<?> mekanismCapability;

        public MekanismEnergyGeneratorCapabilityProvider(EnergyPowerGenerator energyGenerator) {
            this.mekanismProxy = MekanismEnergyGeneratorWrapper.createProxy(energyGenerator);
            Capability cap = null;
            try {
                Class<?> capabilitiesClass = Class.forName("mekanism.common.capabilities.Capabilities");
                Field energyField = capabilitiesClass.getDeclaredField("STRICT_ENERGY");
                cap = (Capability)energyField.get(null);
            }
            catch (Exception e) {
                log.warn("Failed to get Mekanism STRICT_ENERGY capability: {}", (Object)e.getMessage());
            }
            this.mekanismCapability = cap;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
            if (this.mekanismCapability != null && capability == this.mekanismCapability && this.mekanismProxy != null) {
                Object proxy = this.mekanismProxy;
                return LazyOptional.of(() -> proxy);
            }
            return LazyOptional.empty();
        }
    }

    private static class ForgeEnergyConsumerCapabilityProvider
    implements ICapabilityProvider {
        private final LazyOptional<ForgeEnergyWrapper> forgeEnergyOptional = LazyOptional.of(() -> new ForgeEnergyWrapper(energyConsumer));

        public ForgeEnergyConsumerCapabilityProvider(EnergyPowerConsumer energyConsumer) {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
            if (capability == ForgeCapabilities.ENERGY) {
                return this.forgeEnergyOptional.cast();
            }
            return LazyOptional.empty();
        }
    }
}

