/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy.compat;

import de.markusbordihn.scraptechworkshop.energy.EnergyConverter;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerConsumer;
import net.minecraftforge.energy.IEnergyStorage;

public class ForgeEnergyWrapper
implements IEnergyStorage {
    private final EnergyPowerConsumer energyConsumer;

    public ForgeEnergyWrapper(EnergyPowerConsumer energyConsumer) {
        this.energyConsumer = energyConsumer;
    }

    public int receiveEnergy(int forgeEnergyReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int milliampereHourToReceive = EnergyConverter.forgeEnergyToMilliampereHour(forgeEnergyReceive);
        int milliampereHourReceived = this.energyConsumer.receiveEnergy(milliampereHourToReceive, simulate);
        return EnergyConverter.milliampereHourToForgeEnergy(milliampereHourReceived);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return EnergyConverter.milliampereHourToForgeEnergy(this.energyConsumer.getCurrentEnergy());
    }

    public int getMaxEnergyStored() {
        return EnergyConverter.milliampereHourToForgeEnergy(this.energyConsumer.getEnergyCapacity());
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return this.energyConsumer.canAcceptExternalEnergy();
    }
}

