/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.environment;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

public class WindCalculator {
    private static final int MIN_HEIGHT = 64;
    private static final int OPTIMAL_HEIGHT = 150;
    private static final int MAX_WIND_SPEED = 250;
    private static final Direction[] HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public static int calculateWindSpeed(Level level, BlockPos pos) {
        if (level == null || pos == null || !level.m_45527_(pos)) {
            return 0;
        }
        int baseSpeed = 80;
        int height = pos.m_123342_();
        if (height > 64) {
            int heightDiff = Math.min(height - 64, 86);
            int heightBonus = (int)((double)heightDiff * 0.7);
            baseSpeed += heightBonus;
        }
        float directObstructionPenalty = WindCalculator.calculateDirectObstruction(level, pos);
        baseSpeed = (int)((float)baseSpeed * (1.0f - directObstructionPenalty));
        int opennessBonus = (int)(WindCalculator.calculateOpenness(level, pos) * 40.0f);
        baseSpeed += opennessBonus;
        int chunkX = pos.m_123341_() >> 4;
        int chunkZ = pos.m_123343_() >> 4;
        int chunkVariation = (int)(((long)chunkX * 31L + (long)chunkZ & Integer.MAX_VALUE) % 30L) - 15;
        baseSpeed += chunkVariation;
        float timeModifier = 1.0f + 0.2f * (float)Math.sin((double)(level.m_46468_() % 24000L) / 24000.0 * Math.PI * 2.0);
        baseSpeed = (int)((float)baseSpeed * timeModifier);
        return Math.max(0, Math.min(250, baseSpeed));
    }

    private static float calculateDirectObstruction(Level level, BlockPos turbineBladePos) {
        int blockedDirections = 0;
        for (Direction direction : HORIZONTAL_DIRECTIONS) {
            BlockPos neighborPos = turbineBladePos.m_121945_(direction);
            if (level.m_8055_(neighborPos).m_60795_()) continue;
            ++blockedDirections;
        }
        return (float)blockedDirections * 0.25f;
    }

    private static float calculateOpenness(Level level, BlockPos pos) {
        int blockedCount = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0 || level.m_8055_(pos.m_7918_(x, 0, z)).m_60795_()) continue;
                ++blockedCount;
            }
        }
        return 1.0f - (float)blockedCount / 8.0f;
    }

    public static int calculatePowerGeneration(int windSpeed) {
        if (windSpeed < 30) {
            return 0;
        }
        return (int)((float)windSpeed * 0.2f);
    }
}

