/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item.component;

import de.markusbordihn.scraptechworkshop.energy.EnergyCell;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EnergyCellItem
extends Item
implements EnergyCell {
    public static final String ID = "energy_cell";
    public static final int CAPACITY_MAH = 5000;
    public static final float VOLTAGE = 3.2f;
    public static final int DEFAULT_CHARGE_RATE = 25;
    public static final int DEFAULT_DISCHARGE_RATE = 100;
    private final int initialEnergy;
    private final int chargeRate;
    private final int dischargeRate;

    public EnergyCellItem(Item.Properties properties) {
        this(properties, 5000, 25, 100);
    }

    public EnergyCellItem(Item.Properties properties, int initialEnergy) {
        this(properties, initialEnergy, 25, 100);
    }

    public EnergyCellItem(Item.Properties properties, int initialEnergy, int chargeRate, int dischargeRate) {
        super(properties.m_41487_(1).m_41503_(5000).m_41497_(Rarity.UNCOMMON));
        this.initialEnergy = Math.max(1, Math.min(initialEnergy, 5000));
        this.chargeRate = Math.max(1, chargeRate);
        this.dischargeRate = Math.max(1, dischargeRate);
    }

    @Override
    public int getCapacity() {
        return 5000;
    }

    @Override
    public int getChargeRate() {
        return this.chargeRate;
    }

    @Override
    public int getDischargeRate() {
        return this.dischargeRate;
    }

    @Override
    public ItemStack createEmptyBattery() {
        return new ItemStack((ItemLike)ModItems.EMPTY_ENERGY_CELL.get());
    }

    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.setEnergy(stack, this.initialEnergy);
        return stack;
    }

    public boolean m_142522_(ItemStack itemStack) {
        return true;
    }

    @Override
    public int m_142159_(ItemStack itemStack) {
        return EnergyCell.super.m_142159_(itemStack);
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"item.scrap_tech_workshop.energy_cell.description"));
        int energy = this.getEnergy(itemStack);
        tooltipComponents.add((Component)Component.m_237113_((String)(energy + " / 5000 mAh (3.2V)")).m_130938_(style -> style.m_178520_(this.m_142159_(itemStack))));
        super.m_7373_(itemStack, level, tooltipComponents, isAdvanced);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }
}

