/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.item.tool;

import de.markusbordihn.scraptechworkshop.config.MultitoolConfig;
import de.markusbordihn.scraptechworkshop.data.energy.EnergyData;
import de.markusbordihn.scraptechworkshop.data.multitool.DisplayMode;
import de.markusbordihn.scraptechworkshop.data.multitool.ScrapMultitoolData;
import de.markusbordihn.scraptechworkshop.data.multitool.ToolMode;
import de.markusbordihn.scraptechworkshop.energy.EnergyManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public record ToolModeDetector(ItemStack itemStack) {
    public ToolMode getToolModeForBlock(BlockState state) {
        if (state.m_204336_(BlockTags.f_144280_)) {
            return ToolMode.AXE;
        }
        if (state.m_204336_(BlockTags.f_144282_)) {
            return ToolMode.PICKAXE;
        }
        if (state.m_204336_(BlockTags.f_144283_)) {
            return ToolMode.SHOVEL;
        }
        if (state.m_204336_(BlockTags.f_144281_)) {
            return ToolMode.HOE;
        }
        if (this.canBeHoed(state)) {
            return ToolMode.HOE;
        }
        return ToolMode.NONE;
    }

    public void updateToolMode(Player player, BlockState targetBlock) {
        ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(this.itemStack);
        EnergyData energyData = EnergyManager.getEnergyData(this.itemStack, MultitoolConfig.energyMax);
        if (!data.hasBattery() || !energyData.hasEnergy(MultitoolConfig.energyPerBlock)) {
            if (!ToolMode.DEFAULT.getId().equals(data.activeMode())) {
                ScrapMultitoolData newData = data.withActiveMode(ToolMode.DEFAULT.getId());
                newData.saveToItemStack(this.itemStack);
                DisplayMode displayMode = new DisplayMode(this.itemStack);
                displayMode.updateModel(ToolMode.DEFAULT, newData.getBatteryLevel());
            }
            return;
        }
        ToolMode newMode = ToolMode.DEFAULT;
        if (targetBlock != null) {
            if (targetBlock.m_204336_(BlockTags.f_144280_)) {
                newMode = ToolMode.AXE;
            } else if (targetBlock.m_204336_(BlockTags.f_144282_)) {
                newMode = ToolMode.PICKAXE;
            } else if (targetBlock.m_204336_(BlockTags.f_144283_)) {
                newMode = ToolMode.SHOVEL;
            } else if (targetBlock.m_204336_(BlockTags.f_144281_) || this.canBeHoed(targetBlock)) {
                newMode = ToolMode.HOE;
            }
        }
        if (!newMode.getId().equals(data.activeMode())) {
            ScrapMultitoolData newData = data.withActiveMode(newMode.getId());
            newData.saveToItemStack(this.itemStack);
            DisplayMode displayMode = new DisplayMode(this.itemStack);
            displayMode.updateModel(newMode, newData.getBatteryLevel());
        }
    }

    public BlockState getTargetBlock(Level level, Player player) {
        Vec3 direction;
        Vec3 end;
        Vec3 start = player.m_20299_(1.0f);
        BlockHitResult hitResult = level.m_45547_(new ClipContext(start, end = start.m_82549_((direction = player.m_20154_()).m_82490_((double)MultitoolConfig.raycastDistance)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            return level.m_8055_(hitResult.m_82425_());
        }
        return null;
    }

    private boolean canBeHoed(BlockState state) {
        Block block = state.m_60734_();
        return block == Blocks.f_50440_ || block == Blocks.f_50493_ || block == Blocks.f_50546_ || block == Blocks.f_152481_ || block == Blocks.f_152549_;
    }
}

