/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.loot;

import de.markusbordihn.scraptechworkshop.config.ScrapPileConfig;
import de.markusbordihn.scraptechworkshop.data.ScrapPileVariant;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.loot.WeightedLootTable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class ScrapLootTables {
    private static final Object METAL_LOCK = new Object();
    private static final Object TECH_LOCK = new Object();
    private static final Object MIXED_LOCK = new Object();
    private static volatile WeightedLootTable<Item> metalTable;
    private static volatile WeightedLootTable<Item> techTable;
    private static volatile WeightedLootTable<Item> mixedTable;

    private ScrapLootTables() {
    }

    public static ItemStack generateRandomScrap(ScrapPileVariant variant, RandomSource random) {
        WeightedLootTable<Item> table = switch (variant) {
            case ScrapPileVariant.METAL -> ScrapLootTables.getMetalTable();
            case ScrapPileVariant.TECH -> ScrapLootTables.getTechTable();
            default -> ScrapLootTables.getMixedTable();
        };
        return new ItemStack((ItemLike)table.generate(random));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WeightedLootTable<Item> getMetalTable() {
        WeightedLootTable<Item> table = metalTable;
        if (table == null) {
            Object object = METAL_LOCK;
            synchronized (object) {
                table = metalTable;
                if (table == null) {
                    metalTable = table = ScrapLootTables.createMetalTable();
                }
            }
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WeightedLootTable<Item> getTechTable() {
        WeightedLootTable<Item> table = techTable;
        if (table == null) {
            Object object = TECH_LOCK;
            synchronized (object) {
                table = techTable;
                if (table == null) {
                    techTable = table = ScrapLootTables.createTechTable();
                }
            }
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WeightedLootTable<Item> getMixedTable() {
        WeightedLootTable<Item> table = mixedTable;
        if (table == null) {
            Object object = MIXED_LOCK;
            synchronized (object) {
                table = mixedTable;
                if (table == null) {
                    mixedTable = table = ScrapLootTables.createMixedTable();
                }
            }
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetTables() {
        Object object = METAL_LOCK;
        synchronized (object) {
            metalTable = null;
        }
        object = TECH_LOCK;
        synchronized (object) {
            techTable = null;
        }
        object = MIXED_LOCK;
        synchronized (object) {
            mixedTable = null;
        }
    }

    private static WeightedLootTable<Item> createMetalTable() {
        return new WeightedLootTable<Item>(new WeightedLootTable.Entry<Item>(ModItems.ALLOY_SCRAP.get(), ScrapPileConfig.alloyScrapWeight), new WeightedLootTable.Entry<Item>(ModItems.METAL_SCRAP.get(), ScrapPileConfig.metalScrapWeight), new WeightedLootTable.Entry<Item>(ModItems.IRON_SCRAP.get(), ScrapPileConfig.ironScrapWeight), new WeightedLootTable.Entry<Item>(ModItems.COPPER_SCRAP.get(), ScrapPileConfig.copperScrapWeight), new WeightedLootTable.Entry<Item>(ModItems.GOLD_SCRAP.get(), ScrapPileConfig.goldScrapWeight));
    }

    private static WeightedLootTable<Item> createTechTable() {
        return new WeightedLootTable<Item>(new WeightedLootTable.Entry<Item>(ModItems.TECH_SCRAP.get(), ScrapPileConfig.techScrapWeight), new WeightedLootTable.Entry<Item>(ModItems.CIRCUIT_SCRAP.get(), ScrapPileConfig.circuitScrapWeight), new WeightedLootTable.Entry<Item>(ModItems.COIL_SCRAP.get(), ScrapPileConfig.coilScrapWeight), new WeightedLootTable.Entry<Item>(ModItems.CAPACITOR_SCRAP.get(), ScrapPileConfig.capacitorScrapWeight), new WeightedLootTable.Entry<Item>(ModItems.ENERGY_CELL_SCRAP.get(), ScrapPileConfig.energyCellScrapWeight));
    }

    private static WeightedLootTable<Item> createMixedTable() {
        return new WeightedLootTable<Item>(new WeightedLootTable.Entry<Item>(ModItems.METAL_SCRAP.get(), ScrapPileConfig.metalScrapWeight), new WeightedLootTable.Entry<Item>(ModItems.IRON_SCRAP.get(), ScrapPileConfig.ironScrapWeight), new WeightedLootTable.Entry<Item>(ModItems.COPPER_SCRAP.get(), ScrapPileConfig.copperScrapWeight), new WeightedLootTable.Entry<Item>(ModItems.TECH_SCRAP.get(), ScrapPileConfig.techScrapWeight), new WeightedLootTable.Entry<Item>(ModItems.PLASTIC_SCRAP.get(), ScrapPileConfig.plasticScrapWeight), new WeightedLootTable.Entry<Item>(ModItems.WOOD_SCRAP.get(), ScrapPileConfig.woodScrapWeight), new WeightedLootTable.Entry<Item>(ModItems.CRYSTAL_SCRAP.get(), ScrapPileConfig.crystalScrapWeight), new WeightedLootTable.Entry<Item>(ModItems.INSULATION_SCRAP.get(), ScrapPileConfig.insulationScrapWeight), new WeightedLootTable.Entry<Item>(ModItems.LUMINOUS_SCRAP.get(), ScrapPileConfig.luminousScrapWeight));
    }

    public static String getDebugInfo() {
        StringBuilder info = new StringBuilder("ScrapLootTables Debug Info:\n");
        if (metalTable != null) {
            info.append("Metal Table: ").append(metalTable.size()).append(" entries, total weight: ").append(metalTable.getTotalWeight()).append("\n");
        } else {
            info.append("Metal Table: Not initialized\n");
        }
        if (techTable != null) {
            info.append("Tech Table: ").append(techTable.size()).append(" entries, total weight: ").append(techTable.getTotalWeight()).append("\n");
        } else {
            info.append("Tech Table: Not initialized\n");
        }
        if (mixedTable != null) {
            info.append("Mixed Table: ").append(mixedTable.size()).append(" entries, total weight: ").append(mixedTable.getTotalWeight()).append("\n");
        } else {
            info.append("Mixed Table: Not initialized\n");
        }
        return info.toString();
    }
}

