/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu;

import de.markusbordihn.scraptechworkshop.data.energy.EnergyFlowStatus;
import de.markusbordihn.scraptechworkshop.data.energy.ExternalEnergyFlowStatus;
import de.markusbordihn.scraptechworkshop.menu.BaseMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;

public abstract class EnergyPowerMenu
extends BaseMenu {
    public static final int ENERGY_TAB_BATTERY_SLOT_X = -20;
    public static final int ENERGY_TAB_BATTERY_SLOT_Y = 6;
    protected static final int ENERGY_DATA_INDEX = 0;
    protected static final int ENERGY_CAPACITY_DATA_INDEX = 1;
    protected static final int ENERGY_FLOW_STATUS_DATA_INDEX = 2;
    protected static final int EXTERNAL_ENERGY_FLOW_STATUS_DATA_INDEX = 3;
    protected static final int ENERGY_RECEIVE_AMOUNT_DATA_INDEX = 4;
    protected static final int ENERGY_DISTRIBUTE_AMOUNT_DATA_INDEX = 5;
    protected final ContainerData energyData;

    protected EnergyPowerMenu(MenuType<?> menuType, int windowId, ContainerData energyData) {
        super(menuType, windowId);
        this.energyData = energyData != null ? energyData : new SimpleContainerData(6);
        this.m_38884_(this.energyData);
    }

    public int getCurrentEnergy() {
        return this.energyData.m_6413_(0);
    }

    public int getEnergyCapacity() {
        return this.energyData.m_6413_(1);
    }

    public EnergyFlowStatus getEnergyFlowStatus() {
        int statusOrdinal = this.energyData.m_6413_(2);
        EnergyFlowStatus[] statuses = EnergyFlowStatus.values();
        return statusOrdinal >= 0 && statusOrdinal < statuses.length ? statuses[statusOrdinal] : EnergyFlowStatus.IDLE;
    }

    public ExternalEnergyFlowStatus getExternalEnergyFlowStatus() {
        int statusOrdinal = this.energyData.m_6413_(3);
        ExternalEnergyFlowStatus[] statuses = ExternalEnergyFlowStatus.values();
        return statusOrdinal >= 0 && statusOrdinal < statuses.length ? statuses[statusOrdinal] : ExternalEnergyFlowStatus.IDLE;
    }

    public int getEnergyReceiveAmount() {
        return this.energyData.m_6413_(4);
    }

    public int getEnergyDistributeAmount() {
        return this.energyData.m_6413_(5);
    }

    public abstract int getBatterySlotIndex();
}

