/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu;

import de.markusbordihn.scraptechworkshop.block.entity.floatingscrapcollector.FloatingScrapCollectorBlockEntity;
import de.markusbordihn.scraptechworkshop.item.ScrapFilterItem;
import de.markusbordihn.scraptechworkshop.menu.BaseMenu;
import de.markusbordihn.scraptechworkshop.menu.slots.DummySlot;
import de.markusbordihn.scraptechworkshop.menu.slots.FloatingCollectorOutputSlot;
import de.markusbordihn.scraptechworkshop.menu.slots.ScrapFilterSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FloatingScrapCollectorMenu
extends BaseMenu {
    public static final int NET_SLOT_X = 8;
    public static final int NET_SLOT_Y = 17;
    public static final int OUTPUT_GRID_START_X = 80;
    public static final int OUTPUT_GRID_START_Y = 17;
    public static final int OUTPUT_GRID_COLUMNS = 3;
    public static final int OUTPUT_GRID_ROWS = 3;
    public static final int PLAYER_INVENTORY_START_Y = 94;
    public static final int PROGRESS_BAR_X = 35;
    public static final int PROGRESS_BAR_Y = 17;
    public static final int PROGRESS_BAR_WIDTH = 18;
    public static final int PROGRESS_BAR_HEIGHT = 54;
    public static final int DURABILITY_BAR_X = 8;
    public static final int DURABILITY_BAR_Y = 38;
    public static final int DURABILITY_BAR_WIDTH = 16;
    public static final int DURABILITY_BAR_HEIGHT = 4;
    public static final int ADDITIONAL_CONTAINER_DATA_SIZE = 2;
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String LOG_PREFIX = "[FloatingScrapCollectorMenu]";
    public static MenuType<FloatingScrapCollectorMenu> MENU_TYPE;
    private final FloatingScrapCollectorBlockEntity blockEntity;
    private final Level level;
    private final ContainerData additionalData;
    private final SimpleContainer dummyContainer;
    private final BlockPos blockPos;

    public FloatingScrapCollectorMenu(int windowId, Inventory playerInventory, FriendlyByteBuf additionalData) {
        this(windowId, playerInventory, FloatingScrapCollectorMenu.getBlockEntityFromData(playerInventory, additionalData), (ContainerData)new SimpleContainerData(2));
    }

    public FloatingScrapCollectorMenu(int windowId, Inventory playerInventory, BlockEntity entity, ContainerData additionalData) {
        super(MENU_TYPE, windowId);
        this.level = playerInventory.f_35978_.m_9236_();
        this.additionalData = additionalData != null ? additionalData : new SimpleContainerData(2);
        this.dummyContainer = new SimpleContainer(10);
        if (entity instanceof FloatingScrapCollectorBlockEntity) {
            FloatingScrapCollectorBlockEntity collectorEntity;
            this.blockEntity = collectorEntity = (FloatingScrapCollectorBlockEntity)entity;
            this.blockPos = collectorEntity.m_58899_();
        } else {
            log.error("{} Expected FloatingScrapCollectorBlockEntity but got {} at {}", (Object)LOG_PREFIX, (Object)entity, entity != null ? entity.m_58899_() : "NULL");
            this.blockEntity = null;
            this.blockPos = null;
        }
        FloatingScrapCollectorMenu.m_38869_((Container)playerInventory, (int)10);
        this.addCollectorSlots();
        this.addPlayerInventoryAndHotbar(playerInventory, 94);
        this.m_38884_(this.additionalData);
    }

    private static BlockEntity getBlockEntityFromData(Inventory playerInventory, FriendlyByteBuf additionalData) {
        BlockPos pos = additionalData.m_130135_();
        return playerInventory.f_35978_.m_9236_().m_7702_(pos);
    }

    private void addCollectorSlots() {
        FloatingScrapCollectorBlockEntity entityToUse = this.getValidBlockEntity();
        if (entityToUse != null) {
            this.m_38897_(new ScrapFilterSlot(entityToUse, 0, 8, 17));
            int outputIndex = 1;
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    this.m_38897_(new FloatingCollectorOutputSlot(entityToUse, outputIndex++, 80 + col * 18, 17 + row * 18));
                }
            }
        } else {
            for (int i = 0; i < 10; ++i) {
                this.m_38897_(new DummySlot((Container)this.dummyContainer, i, -1000, -1000));
            }
        }
    }

    private FloatingScrapCollectorBlockEntity getValidBlockEntity() {
        BlockEntity entity;
        if (this.blockEntity != null) {
            return this.blockEntity;
        }
        if (this.blockPos != null && this.level != null && (entity = this.level.m_7702_(this.blockPos)) instanceof FloatingScrapCollectorBlockEntity) {
            FloatingScrapCollectorBlockEntity collectorEntity = (FloatingScrapCollectorBlockEntity)entity;
            log.debug("{} Resolved BlockEntity on delayed lookup", (Object)LOG_PREFIX);
            return collectorEntity;
        }
        return null;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack returnStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            returnStack = slotStack.m_41777_();
            if (index < 10) {
                if (!this.m_38903_(slotStack, 10, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else if (slotStack.m_41720_() instanceof ScrapFilterItem) {
                if (!this.m_38903_(slotStack, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == returnStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return returnStack;
    }

    public boolean m_6875_(Player player) {
        if (this.blockEntity == null) {
            return false;
        }
        return FloatingScrapCollectorMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    public int getProgress() {
        return this.additionalData.m_6413_(0);
    }

    public int getMaxProgress() {
        return this.additionalData.m_6413_(1);
    }

    public int getScaledProgress() {
        int progress = this.getProgress();
        int maxProgress = this.getMaxProgress();
        return maxProgress != 0 && progress != 0 ? progress * 54 / maxProgress : 0;
    }

    public float getNetDurabilityPercent() {
        if (this.blockEntity == null) {
            return 0.0f;
        }
        ItemStack netStack = this.blockEntity.getContainer().m_8020_(0);
        if (netStack.m_41619_() || !(netStack.m_41720_() instanceof ScrapFilterItem)) {
            return 0.0f;
        }
        return ScrapFilterItem.getDurabilityPercent(netStack);
    }

    public FloatingScrapCollectorBlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

