/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu;

import de.markusbordihn.scraptechworkshop.block.entity.windturbine.ScrapWindTurbineBlockEntity;
import de.markusbordihn.scraptechworkshop.block.windturbine.ScrapWindTurbineBlock;
import de.markusbordihn.scraptechworkshop.data.windturbine.ScrapWindTurbineStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerGenerator;
import de.markusbordihn.scraptechworkshop.menu.EnergyPowerGeneratorMenu;
import de.markusbordihn.scraptechworkshop.menu.slots.DummySlot;
import de.markusbordihn.scraptechworkshop.menu.slots.EnergyCellSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapWindTurbineMenu
extends EnergyPowerGeneratorMenu {
    public static final int CHARGING_BATTERY_SLOT_X = 135;
    public static final int CHARGING_BATTERY_SLOT_Y = 43;
    public static final int PLAYER_INVENTORY_START_Y = 119;
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String LOG_PREFIX = "[SCRAP_WIND_TURBINE]";
    private static final int PLAYER_INVENTORY_START_INDEX = 2;
    private static final int PLAYER_INVENTORY_END_INDEX = 29;
    private static final int PLAYER_HOTBAR_END_INDEX = 38;
    private static final int ADDITIONAL_CONTAINER_DATA_SIZE = 2;
    public static MenuType<ScrapWindTurbineMenu> MENU_TYPE;
    private final ScrapWindTurbineBlockEntity blockEntity;
    private final Level level;
    private final ContainerData additionalData;
    private final SimpleContainer dummyContainer;
    private final BlockPos blockPos;

    public ScrapWindTurbineMenu(int windowId, Inventory playerInventory, FriendlyByteBuf additionalData) {
        this(windowId, playerInventory, ScrapWindTurbineMenu.getBlockEntityFromData(playerInventory, additionalData), (ContainerData)new SimpleContainerData(2));
    }

    public ScrapWindTurbineMenu(int windowId, Inventory playerInventory, BlockEntity entity, ContainerData additionalData) {
        SimpleContainerData simpleContainerData;
        if (entity instanceof EnergyPowerGenerator) {
            EnergyPowerGenerator generator = (EnergyPowerGenerator)entity;
            simpleContainerData = generator.getEnergyPowerData();
        } else {
            simpleContainerData = new SimpleContainerData(6);
        }
        super(MENU_TYPE, windowId, (ContainerData)simpleContainerData);
        this.level = playerInventory.f_35978_.m_9236_();
        this.additionalData = additionalData != null ? additionalData : new SimpleContainerData(2);
        this.dummyContainer = new SimpleContainer(2);
        if (entity instanceof ScrapWindTurbineBlockEntity) {
            ScrapWindTurbineBlockEntity windTurbineEntity;
            this.blockEntity = windTurbineEntity = (ScrapWindTurbineBlockEntity)entity;
            this.blockPos = windTurbineEntity.m_58899_();
        } else {
            log.error("{} Expected ScrapWindTurbineBlockEntity but got {} at {}", (Object)LOG_PREFIX, (Object)entity, entity != null ? entity.m_58899_() : "NULL");
            this.blockEntity = null;
            this.blockPos = null;
        }
        ScrapWindTurbineMenu.m_38869_((Container)playerInventory, (int)2);
        this.addWindTurbineSlots();
        this.addPlayerInventoryAndHotbar(playerInventory, 119);
        this.m_38884_(this.additionalData);
    }

    private static BlockEntity getBlockEntityFromData(Inventory playerInventory, FriendlyByteBuf additionalData) {
        if (additionalData == null) {
            log.error("{} additionalData is NULL", (Object)LOG_PREFIX);
            return null;
        }
        try {
            BlockPos pos = additionalData.m_130135_();
            Level level = playerInventory.f_35978_.m_9236_();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity == null) {
                log.error("{} BlockEntity is NULL at {}", (Object)LOG_PREFIX, (Object)pos);
                return null;
            }
            return blockEntity;
        }
        catch (Exception e) {
            log.error("{} Error reading BlockEntity from additionalData: {}", (Object)LOG_PREFIX, (Object)e.getMessage());
            return null;
        }
    }

    private void addWindTurbineSlots() {
        ScrapWindTurbineBlockEntity entityToUse = this.getValidBlockEntity();
        if (entityToUse != null) {
            this.m_38897_(new EnergyCellSlot((Container)entityToUse, 0, -20, 6));
            this.m_38897_(new EnergyCellSlot((Container)entityToUse, 1, 135, 43));
        } else {
            for (int i = 0; i < 2; ++i) {
                this.m_38897_(new DummySlot((Container)this.dummyContainer, i, -1000, -1000));
            }
            log.warn("{} Using dummy slots because BlockEntity is not available", (Object)LOG_PREFIX);
        }
    }

    private ScrapWindTurbineBlockEntity getValidBlockEntity() {
        BlockEntity entity;
        if (this.blockEntity != null) {
            return this.blockEntity;
        }
        if (this.blockPos != null && this.level != null && (entity = this.level.m_7702_(this.blockPos)) instanceof ScrapWindTurbineBlockEntity) {
            ScrapWindTurbineBlockEntity windTurbineEntity = (ScrapWindTurbineBlockEntity)entity;
            log.debug("{} Resolved BlockEntity on delayed lookup", (Object)LOG_PREFIX);
            return windTurbineEntity;
        }
        return null;
    }

    public int getWindSpeed() {
        return this.additionalData.m_6413_(0);
    }

    public int getPowerGeneration() {
        return this.additionalData.m_6413_(1);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotItem = slot.m_7993_();
            itemStack = slotItem.m_41777_();
            if (index < 2 ? !this.m_38903_(slotItem, 2, 38, true) : index < 38 && !this.m_38903_(slotItem, 0, 2, false)) {
                return ItemStack.f_41583_;
            }
            if (slotItem.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemStack;
    }

    public boolean m_6875_(Player player) {
        if (this.blockEntity != null && this.blockEntity.m_58904_() != null) {
            return ScrapWindTurbineMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.blockEntity.m_58904_(), (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
        }
        return false;
    }

    public ScrapWindTurbineBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public ScrapWindTurbineStatus getWindTurbineStatus() {
        if (this.blockEntity == null || this.blockEntity.m_58904_() == null) {
            return ScrapWindTurbineStatus.IDLE;
        }
        return (ScrapWindTurbineStatus)((Object)this.blockEntity.m_58900_().m_61143_(ScrapWindTurbineBlock.STATUS));
    }

    public int getEnergyTabBatterySlotIndex() {
        return 0;
    }

    public int getChargingBatterySlotIndex() {
        return 1;
    }

    @Override
    public int getBatterySlotIndex() {
        return this.getEnergyTabBatterySlotIndex();
    }
}

