/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.recipe.recycler;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RecyclerByproduct {
    private final Item item;
    private final double chance;
    private final int minCount;
    private final int maxCount;

    public RecyclerByproduct(Item item, double chance) {
        this(item, chance, 1, 1);
    }

    public RecyclerByproduct(Item item, double chance, int minCount, int maxCount) {
        this.item = item;
        this.chance = chance;
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public boolean shouldProduce() {
        return Math.random() < this.chance;
    }

    public ItemStack createStack() {
        int count = this.minCount == this.maxCount ? this.minCount : this.minCount + (int)(Math.random() * (double)(this.maxCount - this.minCount + 1));
        return new ItemStack((ItemLike)this.item, count);
    }

    public Item getItem() {
        return this.item;
    }

    public double getChance() {
        return this.chance;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }
}

