/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.recipe.recycler;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerByproduct;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerMatch;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerOutput;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecyclerRecipeSerializer
implements RecipeSerializer<RecyclerRecipe> {
    public static final RecyclerRecipeSerializer INSTANCE = new RecyclerRecipeSerializer();
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String MATCH_FIELD = "match";
    private static final String PRIMARY_OUTPUT_FIELD = "primary_output";
    private static final String BYPRODUCTS_FIELD = "byproducts";
    private static final String PROCESS_TIME_FIELD = "process_time";
    private static final String WEIGHT_FIELD = "weight";
    private static final String ITEM_FIELD = "item";
    private static final String TAG_FIELD = "tag";
    private static final String COUNT_FIELD = "count";
    private static final String MIN_FIELD = "min";
    private static final String MAX_FIELD = "max";
    private static final String DURABILITY_SCALING_FIELD = "durability_scaling";
    private static final String CHANCE_FIELD = "chance";
    private static final int DEFAULT_WEIGHT = 0;
    private static final int DEFAULT_MIN_COUNT = 1;
    private static final int DEFAULT_MAX_COUNT = 3;
    private static final int DEFAULT_PROCESS_TIME_SECONDS = 10;
    private static final double DEFAULT_CHANCE = 0.0;
    private static final boolean DEFAULT_DURABILITY_SCALING = false;

    private RecyclerRecipeSerializer() {
    }

    public RecyclerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        int processTime;
        JsonObject matchJson = GsonHelper.m_13930_((JsonObject)json, (String)MATCH_FIELD);
        RecyclerMatch match = this.parseMatch(matchJson);
        if (match == null) {
            log.error("Recipe '{}' has invalid match - skipping recipe", (Object)recipeId);
            return null;
        }
        JsonObject primaryOutputJson = GsonHelper.m_13930_((JsonObject)json, (String)PRIMARY_OUTPUT_FIELD);
        RecyclerOutput primaryOutput = this.parseOutput(primaryOutputJson);
        if (primaryOutput == null) {
            log.error("Recipe '{}' has invalid primary output - skipping recipe", (Object)recipeId);
            return null;
        }
        ArrayList<RecyclerByproduct> byproducts = new ArrayList<RecyclerByproduct>();
        if (json.has(BYPRODUCTS_FIELD)) {
            JsonArray byproductsArray = GsonHelper.m_13933_((JsonObject)json, (String)BYPRODUCTS_FIELD);
            for (int i = 0; i < byproductsArray.size(); ++i) {
                JsonObject byproductJson = byproductsArray.get(i).getAsJsonObject();
                RecyclerByproduct byproduct = this.parseByproduct(byproductJson);
                if (byproduct == null) continue;
                byproducts.add(byproduct);
            }
        }
        if ((processTime = GsonHelper.m_13824_((JsonObject)json, (String)PROCESS_TIME_FIELD, (int)10) * 20) < 1) {
            log.error("Process time must be at least 1 tick, got: {} - using default", (Object)(processTime / 20));
            processTime = 200;
        }
        int weight = GsonHelper.m_13824_((JsonObject)json, (String)WEIGHT_FIELD, (int)0);
        return new RecyclerRecipe(recipeId, match, primaryOutput, byproducts, processTime, weight);
    }

    private RecyclerMatch parseMatch(JsonObject matchJson) {
        if (matchJson.has(ITEM_FIELD)) {
            String itemId = GsonHelper.m_13906_((JsonObject)matchJson, (String)ITEM_FIELD);
            ResourceLocation itemLocation = new ResourceLocation(itemId);
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemLocation);
            if (item == null || item == Items.f_41852_) {
                log.error("Invalid item '{}' in recipe match field - item does not exist", (Object)itemId);
                return null;
            }
            return new RecyclerMatch(item);
        }
        if (matchJson.has(TAG_FIELD)) {
            String tagId = GsonHelper.m_13906_((JsonObject)matchJson, (String)TAG_FIELD);
            TagKey tag = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation(tagId));
            return new RecyclerMatch((TagKey<Item>)tag);
        }
        log.error("Recipe match must have either 'item' or 'tag' field");
        return null;
    }

    private RecyclerOutput parseOutput(JsonObject outputJson) {
        String itemId = GsonHelper.m_13906_((JsonObject)outputJson, (String)ITEM_FIELD);
        ResourceLocation itemLocation = new ResourceLocation(itemId);
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemLocation);
        if (item == null || item == Items.f_41852_) {
            log.error("Invalid item '{}' in recipe output field - item does not exist", (Object)itemId);
            return null;
        }
        int minCount = 1;
        int maxCount = 3;
        if (outputJson.has(COUNT_FIELD)) {
            maxCount = GsonHelper.m_13927_((JsonObject)outputJson, (String)COUNT_FIELD);
            minCount = maxCount;
            if (minCount < 1) {
                log.error("Output count must be at least 1, got: {} - using default", (Object)minCount);
                maxCount = 1;
                minCount = 1;
            }
        } else if (outputJson.has(MIN_FIELD) || outputJson.has(MAX_FIELD)) {
            minCount = GsonHelper.m_13824_((JsonObject)outputJson, (String)MIN_FIELD, (int)1);
            maxCount = GsonHelper.m_13824_((JsonObject)outputJson, (String)MAX_FIELD, (int)3);
            if (minCount < 1) {
                log.error("Output min count must be at least 1, got: {} - using default", (Object)minCount);
                minCount = 1;
            }
            if (maxCount < minCount) {
                log.error("Output max count ({}) must be >= min count ({}) - using min as max", (Object)maxCount, (Object)minCount);
                maxCount = minCount;
            }
        }
        boolean durabilityScaling = GsonHelper.m_13855_((JsonObject)outputJson, (String)DURABILITY_SCALING_FIELD, (boolean)false);
        return new RecyclerOutput(item, minCount, maxCount, durabilityScaling);
    }

    private RecyclerByproduct parseByproduct(JsonObject byproductJson) {
        String itemId = GsonHelper.m_13906_((JsonObject)byproductJson, (String)ITEM_FIELD);
        ResourceLocation itemLocation = new ResourceLocation(itemId);
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemLocation);
        if (item == null || item == Items.f_41852_) {
            log.error("Invalid item '{}' in recipe byproduct field - item does not exist", (Object)itemId);
            return null;
        }
        double chance = GsonHelper.m_144742_((JsonObject)byproductJson, (String)CHANCE_FIELD, (double)0.0);
        if (chance < 0.0 || chance > 1.0) {
            log.error("Byproduct chance must be between 0.0 and 1.0, got: {} - clamping", (Object)chance);
            chance = Math.max(0.0, Math.min(1.0, chance));
        }
        int minCount = 1;
        int maxCount = 1;
        if (byproductJson.has(COUNT_FIELD)) {
            maxCount = GsonHelper.m_13927_((JsonObject)byproductJson, (String)COUNT_FIELD);
            minCount = maxCount;
            if (minCount < 1) {
                log.error("Byproduct count must be at least 1, got: {} - using default", (Object)minCount);
                maxCount = 1;
                minCount = 1;
            }
        } else if (byproductJson.has(MIN_FIELD) || byproductJson.has(MAX_FIELD)) {
            minCount = GsonHelper.m_13824_((JsonObject)byproductJson, (String)MIN_FIELD, (int)1);
            maxCount = GsonHelper.m_13824_((JsonObject)byproductJson, (String)MAX_FIELD, (int)minCount);
            if (minCount < 1) {
                log.error("Byproduct min count must be at least 1, got: {} - using default", (Object)minCount);
                minCount = 1;
            }
            if (maxCount < minCount) {
                log.error("Byproduct max count ({}) must be >= min count ({}) - using min as max", (Object)maxCount, (Object)minCount);
                maxCount = minCount;
            }
        }
        return new RecyclerByproduct(item, chance, minCount, maxCount);
    }

    public RecyclerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        RecyclerMatch match;
        boolean isItemMatch = buffer.readBoolean();
        if (isItemMatch) {
            Item item = (Item)buffer.m_236816_((IdMap)BuiltInRegistries.f_257033_);
            match = new RecyclerMatch(item);
        } else {
            ResourceLocation tagId = buffer.m_130281_();
            TagKey tag = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)tagId);
            match = new RecyclerMatch((TagKey<Item>)tag);
        }
        Item primaryItem = (Item)buffer.m_236816_((IdMap)BuiltInRegistries.f_257033_);
        int minCount = buffer.m_130242_();
        int maxCount = buffer.m_130242_();
        boolean durabilityScaling = buffer.readBoolean();
        RecyclerOutput primaryOutput = new RecyclerOutput(primaryItem, minCount, maxCount, durabilityScaling);
        int byproductCount = buffer.m_130242_();
        ArrayList<RecyclerByproduct> byproducts = new ArrayList<RecyclerByproduct>();
        for (int i = 0; i < byproductCount; ++i) {
            Item byproductItem = (Item)buffer.m_236816_((IdMap)BuiltInRegistries.f_257033_);
            double chance = buffer.readDouble();
            int byproductMin = buffer.m_130242_();
            int byproductMax = buffer.m_130242_();
            byproducts.add(new RecyclerByproduct(byproductItem, chance, byproductMin, byproductMax));
        }
        int processTime = buffer.m_130242_();
        int weight = buffer.m_130242_();
        return new RecyclerRecipe(recipeId, match, primaryOutput, byproducts, processTime, weight);
    }

    public void toNetwork(FriendlyByteBuf buffer, RecyclerRecipe recipe) {
        RecyclerMatch match = recipe.match();
        buffer.writeBoolean(match.isItemMatch());
        if (match.isItemMatch()) {
            buffer.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)match.getItem());
        } else {
            buffer.m_130085_(match.getTag().f_203868_());
        }
        RecyclerOutput primaryOutput = recipe.primaryOutput();
        buffer.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)primaryOutput.getItem());
        buffer.m_130130_(primaryOutput.getMinCount());
        buffer.m_130130_(primaryOutput.getMaxCount());
        buffer.writeBoolean(primaryOutput.isDurabilityScaling());
        List<RecyclerByproduct> byproducts = recipe.byproducts();
        buffer.m_130130_(byproducts.size());
        for (RecyclerByproduct byproduct : byproducts) {
            buffer.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)byproduct.getItem());
            buffer.writeDouble(byproduct.getChance());
            buffer.m_130130_(byproduct.getMinCount());
            buffer.m_130130_(byproduct.getMaxCount());
        }
        buffer.m_130130_(recipe.processTime());
        buffer.m_130130_(recipe.weight());
    }
}

