/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.recycler;

import de.markusbordihn.scraptechworkshop.block.entity.recycler.RecyclerBlockEntity;
import de.markusbordihn.scraptechworkshop.data.recycler.RecyclerStatus;
import de.markusbordihn.scraptechworkshop.menu.MenuManager;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;

public class RecyclerBlock
extends class_2237 {
    public static final String ID = "recycler";
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2754<RecyclerStatus> STATUS = class_2754.method_11850((String)"status", RecyclerStatus.class);
    private static final class_265 SHAPE_NORTH_SOUTH = class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0);
    private static final class_265 SHAPE_EAST_WEST = class_2248.method_9541((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);

    public RecyclerBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)POWERED, (Comparable)Boolean.FALSE)).method_11657(STATUS, (Comparable)((Object)RecyclerStatus.IDLE)));
    }

    public static void updateStatus(class_1937 level, class_2338 blockPos, RecyclerStatus newStatus) {
        class_2680 currentState = level.method_8320(blockPos);
        if (currentState.method_26204() instanceof RecyclerBlock && currentState.method_11654(STATUS) != newStatus) {
            level.method_8652(blockPos, (class_2680)currentState.method_11657(STATUS, (Comparable)((Object)newStatus)), 3);
        }
    }

    public class_265 method_9530(class_2680 blockState, class_1922 level, class_2338 blockPos, class_3726 context) {
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)FACING);
        return switch (facing) {
            case class_2350.field_11043, class_2350.field_11035 -> SHAPE_NORTH_SOUTH;
            case class_2350.field_11034, class_2350.field_11039 -> SHAPE_EAST_WEST;
            default -> SHAPE_NORTH_SOUTH;
        };
    }

    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new RecyclerBlockEntity(blockPos, blockState);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
        return RecyclerBlock.method_31618(blockEntityType, RecyclerBlockEntity.TYPE, RecyclerBlockEntity::tick);
    }

    public class_1269 method_9534(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        class_2586 class_25862;
        if (!level.field_9236 && (class_25862 = level.method_8321(blockPos)) instanceof RecyclerBlockEntity) {
            RecyclerBlockEntity recyclerBlockEntity = (RecyclerBlockEntity)class_25862;
            this.openRecyclerMenu(player, recyclerBlockEntity);
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    private void openRecyclerMenu(class_1657 player, RecyclerBlockEntity recyclerBlockEntity) {
        MenuManager.openMenu(player, recyclerBlockEntity);
    }

    public void method_9536(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 newState, boolean isMoving) {
        if (!blockState.method_27852(newState.method_26204())) {
            class_2586 blockEntity = level.method_8321(blockPos);
            if (blockEntity instanceof RecyclerBlockEntity) {
                RecyclerBlockEntity recyclerBlockEntity = (RecyclerBlockEntity)blockEntity;
                class_1264.method_5451((class_1937)level, (class_2338)blockPos, (class_1263)recyclerBlockEntity.getContainer());
            }
            super.method_9536(blockState, level, blockPos, newState, isMoving);
        }
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153())).method_11657((class_2769)POWERED, (Comparable)Boolean.FALSE)).method_11657(STATUS, (Comparable)((Object)RecyclerStatus.IDLE));
    }

    public class_2680 method_9598(class_2680 blockState, class_2470 rotation) {
        return (class_2680)blockState.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)blockState.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 blockState, class_2415 mirror) {
        return blockState.method_26186(mirror.method_10345((class_2350)blockState.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, POWERED, STATUS});
    }

    public boolean method_9498(class_2680 blockState) {
        return true;
    }

    public int method_9572(class_2680 blockState, class_1937 level, class_2338 pos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof RecyclerBlockEntity) {
            RecyclerBlockEntity recyclerBlockEntity = (RecyclerBlockEntity)blockEntity;
            return recyclerBlockEntity.getRedstoneSignal();
        }
        return 0;
    }

    public void method_9548(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1297 entity) {
        int spaceAvailable;
        if (level.field_9236 || !(entity instanceof class_1542)) {
            return;
        }
        class_1542 itemEntity = (class_1542)entity;
        class_2586 class_25862 = level.method_8321(blockPos);
        if (!(class_25862 instanceof RecyclerBlockEntity)) {
            return;
        }
        RecyclerBlockEntity recyclerBlockEntity = (RecyclerBlockEntity)class_25862;
        class_1799 droppedStack = itemEntity.method_6983();
        if (droppedStack.method_7960()) {
            return;
        }
        class_1799 inputStack = recyclerBlockEntity.getContainer().method_5438(0);
        if (inputStack.method_7960()) {
            recyclerBlockEntity.getContainer().method_5447(0, droppedStack.method_7972());
            itemEntity.method_31472();
        } else if (class_1799.method_31577((class_1799)inputStack, (class_1799)droppedStack) && (spaceAvailable = inputStack.method_7914() - inputStack.method_7947()) > 0) {
            int toTransfer = Math.min(spaceAvailable, droppedStack.method_7947());
            inputStack.method_7933(toTransfer);
            droppedStack.method_7934(toTransfer);
            if (droppedStack.method_7960()) {
                itemEntity.method_31472();
            }
        }
    }
}

