/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client;

import de.markusbordihn.scraptechworkshop.client.ClientEvents;
import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogPlayerManager;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogManager;
import de.markusbordihn.scraptechworkshop.data.scrap.ScrapType;
import de.markusbordihn.scraptechworkshop.item.ItemPropertyFunctions;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.item.hololog.HoloPadItem;
import de.markusbordihn.scraptechworkshop.registry.block.FloatingScrapCollectorBlockRegistry;
import de.markusbordihn.scraptechworkshop.registry.block.RecyclerBlockRegistry;
import de.markusbordihn.scraptechworkshop.registry.block.ScrapBoxBlockRegistry;
import de.markusbordihn.scraptechworkshop.registry.block.ScrapPileBlockRegistry;
import de.markusbordihn.scraptechworkshop.registry.item.hololog.HoloLogItemRegistry;
import de.markusbordihn.scraptechworkshop.utils.ColorUtils;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_5272;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientEventHandler {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");

    private ClientEventHandler() {
    }

    public static void register() {
        ClientEventHandler.registerItemProperties();
        ClientEventHandler.registerItemColors();
        ClientEventHandler.registerBlockRenderTypes();
        ClientTickEvents.END_CLIENT_TICK.register(client -> HoloLogPlayerManager.tickAll());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> ClientEvents.handleClientDisconnect());
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("scrap_tech_workshop", "hololog_reload");
            }

            public void method_14491(class_3300 resourceManager) {
                log.info("Reloading holologs after resource pack change...");
                HoloLogManager.clearCache();
            }
        });
    }

    private static void registerItemColors() {
        log.info("{} Item Colors for HoloPads ...", (Object)"Register Scrap Tech Workshop");
        for (HoloPadItem item : HoloLogItemRegistry.getHoloPadItems().values()) {
            ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
                class_1792 patt4451$temp;
                if (tintIndex == 0 && (patt4451$temp = stack.method_7909()) instanceof HoloPadItem) {
                    HoloPadItem holoPad = (HoloPadItem)patt4451$temp;
                    return HoloLogManager.loadHoloLog(holoPad.getHoloLogId()).map(data -> ColorUtils.parseHexColor(data.color())).orElse(65535);
                }
                return 0xFFFFFF;
            }, (Object[])new class_1935[]{item});
        }
    }

    private static void registerItemProperties() {
        class_5272.method_27879((class_1792)ModItems.SCRAP_FISHING_ROD.get(), (class_2960)new class_2960("minecraft", "cast"), ItemPropertyFunctions::getFishingRodCastValue);
        class_5272.method_27879((class_1792)ModItems.MAGNET_FISHING_ROD.get(), (class_2960)new class_2960("minecraft", "cast"), ItemPropertyFunctions::getFishingRodCastValue);
    }

    private static void registerBlockRenderTypes() {
        log.debug("{} Block Render Types ...", (Object)"Register Scrap Tech Workshop");
        BlockRenderLayerMap.INSTANCE.putBlock(ScrapPileBlockRegistry.SCRAP_PILE_BLOCK, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)RecyclerBlockRegistry.RECYCLER_BLOCK, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)FloatingScrapCollectorBlockRegistry.FLOATING_SCRAP_COLLECTOR_BLOCK, class_1921.method_23579());
        for (ScrapType type : ScrapType.values()) {
            BlockRenderLayerMap.INSTANCE.putBlock(ScrapBoxBlockRegistry.getScrapBox(type), class_1921.method_23579());
        }
    }
}

