/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.drop;

import de.markusbordihn.scraptechworkshop.config.ScrapDropConfig;
import de.markusbordihn.scraptechworkshop.data.scrap.ScrapDropData;
import de.markusbordihn.scraptechworkshop.data.scrap.ScrapSoundType;
import de.markusbordihn.scraptechworkshop.data.scrap.ScrapType;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.tags.ScrapTypeBlockTags;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class ScrapDropHandler {
    private static final Random RANDOM = new Random();
    private static final Set<class_2338> PLAYER_PLACED_BLOCKS = new HashSet<class_2338>();

    private ScrapDropHandler() {
    }

    public static void handleBlockPlaced(class_2338 blockPos) {
        PLAYER_PLACED_BLOCKS.add(blockPos.method_10062());
    }

    public static void handleBlockBreak(class_3218 serverLevel, class_2338 blockPos, class_2248 brokenBlock) {
        if (PLAYER_PLACED_BLOCKS.remove(blockPos)) {
            return;
        }
        ScrapType scrapType = ScrapTypeBlockTags.getScrapTypeForBlock(brokenBlock);
        if (scrapType == null) {
            return;
        }
        ScrapDropData dropData = ScrapDropHandler.getScrapDropDataForType(scrapType);
        if (dropData == null || !dropData.isEnabled()) {
            return;
        }
        float dropChance = dropData.dropChance() / 100.0f;
        if (RANDOM.nextFloat() < dropChance) {
            class_1799 scrapStack = new class_1799((class_1935)dropData.scrapItem(), 1);
            class_1542 itemEntity = new class_1542((class_1937)serverLevel, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, scrapStack);
            serverLevel.method_8649((class_1297)itemEntity);
            ScrapDropHandler.playDropSound(serverLevel, blockPos, scrapType);
        }
    }

    private static void playDropSound(class_3218 level, class_2338 pos, ScrapType scrapType) {
        if (!ScrapDropConfig.enableDropSounds || ScrapDropConfig.dropSoundVolume <= 0.0f) {
            return;
        }
        class_3414 soundEvent = ScrapSoundType.forScrapType(scrapType).getSoundEvent();
        level.method_8396(null, pos, soundEvent, class_3419.field_15245, Math.min(1.0f, ScrapDropConfig.dropSoundVolume), 0.8f + RANDOM.nextFloat() * 0.4f);
    }

    private static ScrapDropData getScrapDropDataForType(ScrapType scrapType) {
        return switch (scrapType) {
            default -> throw new IncompatibleClassChangeError();
            case ScrapType.BIO -> new ScrapDropData(ModItems.BIO_SCRAP.get(), ScrapDropConfig.bioScrapDropChance);
            case ScrapType.CERAMIC -> new ScrapDropData(ModItems.CERAMIC_SCRAP.get(), ScrapDropConfig.ceramicScrapDropChance);
            case ScrapType.COPPER -> new ScrapDropData(ModItems.COPPER_SCRAP.get(), ScrapDropConfig.copperScrapDropChance);
            case ScrapType.CRYSTAL -> new ScrapDropData(ModItems.CRYSTAL_SCRAP.get(), ScrapDropConfig.crystalScrapDropChance);
            case ScrapType.FASTENER -> new ScrapDropData(ModItems.FASTENER_SCRAP.get(), ScrapDropConfig.fastenerScrapDropChance);
            case ScrapType.FIBER -> new ScrapDropData(ModItems.FIBER_SCRAP.get(), ScrapDropConfig.fiberScrapDropChance);
            case ScrapType.GLASS -> new ScrapDropData(ModItems.GLASS_SCRAP.get(), ScrapDropConfig.glassScrapDropChance);
            case ScrapType.GOLD -> new ScrapDropData(ModItems.GOLD_SCRAP.get(), ScrapDropConfig.goldScrapDropChance);
            case ScrapType.IRON -> new ScrapDropData(ModItems.IRON_SCRAP.get(), ScrapDropConfig.ironScrapDropChance);
            case ScrapType.LUMINOUS -> new ScrapDropData(ModItems.LUMINOUS_SCRAP.get(), ScrapDropConfig.luminousScrapDropChance);
            case ScrapType.METAL -> new ScrapDropData(ModItems.METAL_SCRAP.get(), ScrapDropConfig.metalScrapDropChance);
            case ScrapType.MINERAL -> new ScrapDropData(ModItems.MINERAL_SCRAP.get(), ScrapDropConfig.mineralScrapDropChance);
            case ScrapType.PLASTIC -> new ScrapDropData(ModItems.PLASTIC_SCRAP.get(), ScrapDropConfig.plasticScrapDropChance);
            case ScrapType.RUBBER -> new ScrapDropData(ModItems.RUBBER_SCRAP.get(), ScrapDropConfig.rubberScrapDropChance);
            case ScrapType.TECH -> new ScrapDropData(ModItems.TECH_SCRAP.get(), ScrapDropConfig.techScrapDropChance);
            case ScrapType.WOOD -> new ScrapDropData(ModItems.WOOD_SCRAP.get(), ScrapDropConfig.woodScrapDropChance);
            case ScrapType.CIRCUIT -> new ScrapDropData(ModItems.CIRCUIT_SCRAP.get(), ScrapDropConfig.techScrapDropChance);
            case ScrapType.COIL -> new ScrapDropData(ModItems.COIL_SCRAP.get(), ScrapDropConfig.techScrapDropChance);
            case ScrapType.CAPACITOR -> new ScrapDropData(ModItems.CAPACITOR_SCRAP.get(), ScrapDropConfig.techScrapDropChance);
            case ScrapType.ENERGY_CELL -> new ScrapDropData(ModItems.ENERGY_CELL_SCRAP.get(), ScrapDropConfig.techScrapDropChance);
            case ScrapType.ALLOY -> new ScrapDropData(ModItems.ALLOY_SCRAP.get(), ScrapDropConfig.metalScrapDropChance);
            case ScrapType.INSULATION -> new ScrapDropData(ModItems.INSULATION_SCRAP.get(), ScrapDropConfig.plasticScrapDropChance);
        };
    }
}

