/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu;

import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MenuManager {
    private static final Logger log = LogManager.getLogger((String)"ScrapTechWorkshop");
    private static MenuOpener menuOpener;

    private MenuManager() {
    }

    public static void setMenuOpener(MenuOpener opener) {
        if (menuOpener != null) {
            log.warn("MenuOpener already set! Overwriting with: {}", (Object)opener.getClass().getSimpleName());
        }
        menuOpener = opener;
        log.info("MenuOpener initialized: {}", (Object)opener.getClass().getSimpleName());
    }

    public static void openMenu(class_1657 player, class_2586 blockEntity) {
        if (menuOpener == null) {
            log.error("MenuOpener not initialized! Call setMenuOpener() during mod initialization.");
            return;
        }
        menuOpener.openBlockEntityMenu(player, blockEntity);
    }

    public static void openMenu(class_1657 player, class_1799 itemStack, class_1268 hand) {
        if (menuOpener == null) {
            log.error("MenuOpener not initialized! Call setMenuOpener() during mod initialization.");
            return;
        }
        menuOpener.openItemMenu(player, itemStack, hand);
    }

    public static interface MenuOpener {
        public void openBlockEntityMenu(class_1657 var1, class_2586 var2);

        public void openItemMenu(class_1657 var1, class_1799 var2, class_1268 var3);
    }
}

