/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.registry.item.filter;

import de.markusbordihn.scraptechworkshop.data.floatingscrapcollector.ScrapFilterType;
import de.markusbordihn.scraptechworkshop.item.ScrapFilterItem;
import java.util.LinkedHashMap;
import java.util.Map;

public class ScrapFilterItemRegistry {
    public static final ScrapFilterItem BASIC_SCRAP_FILTER = new ScrapFilterItem(ScrapFilterType.BASIC, 50);
    public static final ScrapFilterItem FINE_MESH_FILTER = new ScrapFilterItem(ScrapFilterType.FINE_MESH, 75);
    public static final ScrapFilterItem MAGNETIC_COIL_FILTER = new ScrapFilterItem(ScrapFilterType.MAGNETIC_COIL, 100);
    public static final ScrapFilterItem ELECTRO_CONDENSATOR_FILTER = new ScrapFilterItem(ScrapFilterType.ELECTRO_CONDENSATOR, 125);
    public static final ScrapFilterItem JUNK_FILTER = new ScrapFilterItem(ScrapFilterType.JUNK_FILTER, 150);
    private static final Map<String, ScrapFilterItem> FILTER_REGISTRY = new LinkedHashMap<String, ScrapFilterItem>();

    private ScrapFilterItemRegistry() {
    }

    public static Map<String, ScrapFilterItem> getAllFilterItems() {
        return FILTER_REGISTRY;
    }

    public static ScrapFilterItem getFilterItem(String id) {
        return FILTER_REGISTRY.get(id);
    }

    static {
        FILTER_REGISTRY.put("basic_scrap_filter", BASIC_SCRAP_FILTER);
        FILTER_REGISTRY.put("fine_mesh_filter", FINE_MESH_FILTER);
        FILTER_REGISTRY.put("magnetic_coil_filter", MAGNETIC_COIL_FILTER);
        FILTER_REGISTRY.put("electro_condensator_filter", ELECTRO_CONDENSATOR_FILTER);
        FILTER_REGISTRY.put("junk_filter", JUNK_FILTER);
    }
}

