/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.collectorstation;

import de.markusbordihn.scraptechworkshop.block.MultiBlockStructure;
import de.markusbordihn.scraptechworkshop.block.entity.collectorstation.CollectorStationBlockEntity;
import de.markusbordihn.scraptechworkshop.data.collectorstation.CollectorStationStatus;
import de.markusbordihn.scraptechworkshop.menu.MenuManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CollectorStationBlock
extends BaseEntityBlock
implements MultiBlockStructure {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<CollectorStationStatus> STATE = EnumProperty.m_61587_((String)"state", CollectorStationStatus.class);
    private static final VoxelShape SHAPE_UPPER_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)12.0, (double)13.0);
    private static final VoxelShape SHAPE_UPPER_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)12.0, (double)15.0);
    private static final VoxelShape SHAPE_UPPER_WEST = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)13.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_UPPER_EAST = Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)15.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_LOWER_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE_LOWER_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_LOWER_WEST = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_LOWER_EAST = Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);

    public CollectorStationBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(STATE, (Comparable)((Object)CollectorStationStatus.NO_POWER))).m_61124_((Property)HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (this.isUpperBlock(state)) {
            return switch (facing) {
                case Direction.SOUTH -> SHAPE_UPPER_SOUTH;
                case Direction.WEST -> SHAPE_UPPER_WEST;
                case Direction.EAST -> SHAPE_UPPER_EAST;
                default -> SHAPE_UPPER_NORTH;
            };
        }
        return switch (facing) {
            case Direction.SOUTH -> SHAPE_LOWER_SOUTH;
            case Direction.WEST -> SHAPE_LOWER_WEST;
            case Direction.EAST -> SHAPE_LOWER_EAST;
            default -> SHAPE_LOWER_NORTH;
        };
    }

    public RenderShape m_7514_(BlockState blockState) {
        return this.isUpperBlock(blockState) ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        if (this.isUpperBlock(blockState)) {
            return null;
        }
        return CollectorStationBlock.m_152132_(blockEntityType, CollectorStationBlockEntity.TYPE, CollectorStationBlockEntity::tick);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        BlockEntity blockEntity;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (this.isUpperBlock(blockState)) {
            blockPos = blockPos.m_7495_();
        }
        if ((blockEntity = level.m_7702_(blockPos)) instanceof CollectorStationBlockEntity) {
            CollectorStationBlockEntity stationEntity = (CollectorStationBlockEntity)blockEntity;
            this.openCollectorStationMenu(player, stationEntity);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(level, blockPos, blockState, placer, itemStack);
        if (!level.f_46443_) {
            this.placeMultiBlock(level, blockPos, blockState, (Block)this);
        }
    }

    private void openCollectorStationMenu(Player player, CollectorStationBlockEntity stationEntity) {
        MenuManager.openMenu(player, stationEntity);
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!blockState.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity;
            if (!this.isUpperBlock(blockState) && (blockEntity = level.m_7702_(blockPos)) instanceof CollectorStationBlockEntity) {
                CollectorStationBlockEntity stationEntity = (CollectorStationBlockEntity)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)stationEntity.getContainer());
            }
            this.removeMultiBlock(level, blockPos, blockState);
            super.m_6810_(blockState, level, blockPos, newState, isMoving);
        }
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return this.isUpperBlock(blockState) ? null : new CollectorStationBlockEntity(blockPos, blockState);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_247087_()) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(STATE, (Comparable)((Object)CollectorStationStatus.NO_POWER))).m_61124_((Property)HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, STATE, HALF});
    }
}

