/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.floatingscrapcollector;

import de.markusbordihn.scraptechworkshop.block.entity.floatingscrapcollector.FloatingScrapCollectorBlockEntity;
import de.markusbordihn.scraptechworkshop.data.floatingscrapcollector.FloatingScrapCollectorStatus;
import de.markusbordihn.scraptechworkshop.data.floatingscrapcollector.ScrapFilterType;
import de.markusbordihn.scraptechworkshop.menu.MenuManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FloatingScrapCollectorBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final String ID = "floating_scrap_collector";
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<FloatingScrapCollectorStatus> STATUS = EnumProperty.m_61587_((String)"status", FloatingScrapCollectorStatus.class);
    public static final EnumProperty<ScrapFilterType> NET_TYPE = EnumProperty.m_61587_((String)"net_type", ScrapFilterType.class);
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);

    public FloatingScrapCollectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(STATUS, (Comparable)((Object)FloatingScrapCollectorStatus.EMPTY))).m_61124_(NET_TYPE, (Comparable)((Object)ScrapFilterType.NONE)));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new FloatingScrapCollectorBlockEntity(blockPos, blockState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return FloatingScrapCollectorBlock.m_152132_(blockEntityType, FloatingScrapCollectorBlockEntity.TYPE, FloatingScrapCollectorBlockEntity::tick);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(blockPos)) instanceof FloatingScrapCollectorBlockEntity) {
            FloatingScrapCollectorBlockEntity blockEntity2 = (FloatingScrapCollectorBlockEntity)blockEntity;
            MenuManager.openMenu(player, blockEntity2);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_6810_(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof FloatingScrapCollectorBlockEntity) {
                FloatingScrapCollectorBlockEntity collector = (FloatingScrapCollectorBlockEntity)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)collector.getContainer());
            }
            super.m_6810_(state, level, blockPos, newState, isMoving);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean isInWater;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        FluidState fluidState = level.m_6425_(pos);
        boolean bl = isInWater = fluidState.m_76152_() == Fluids.f_76193_ || fluidState.m_76152_() == Fluids.f_76192_;
        if (!isInWater) {
            if (player != null && !level.f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)"block.scrap_tech_workshop.floating_scrap_collector.needs_water"), true);
            }
            return null;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_(STATUS, (Comparable)((Object)FloatingScrapCollectorStatus.EMPTY))).m_61124_(NET_TYPE, (Comparable)((Object)ScrapFilterType.NONE));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(blockState, direction, neighborState, level, currentPos, neighborPos);
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, STATUS, NET_TYPE});
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource random) {
        FloatingScrapCollectorStatus status = (FloatingScrapCollectorStatus)((Object)blockState.m_61143_(STATUS));
        if (status != FloatingScrapCollectorStatus.WORKING) {
            return;
        }
        double centerX = (double)blockPos.m_123341_() + 0.5;
        double centerY = (double)blockPos.m_123342_() + 0.3;
        double centerZ = (double)blockPos.m_123343_() + 0.5;
        for (int i = 0; i < 2; ++i) {
            double angle = random.m_188500_() * Math.PI * 2.0;
            double distance = 1.0 + random.m_188500_() * 1.5;
            double offsetX = Math.cos(angle) * distance;
            double offsetZ = Math.sin(angle) * distance;
            double particleX = centerX + offsetX;
            double particleY = centerY + (random.m_188500_() * 0.2 - 0.1);
            double particleZ = centerZ + offsetZ;
            if (random.m_188503_(3) == 0) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123769_, particleX, particleY, particleZ, 0.0, 0.05, 0.0);
            }
            if (random.m_188503_(4) == 0) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, particleX, particleY - 0.2, particleZ, (centerX - particleX) * 0.02, 0.02, (centerZ - particleZ) * 0.02);
            }
            if (random.m_188503_(10) != 0) continue;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123816_, particleX, particleY, particleZ, (centerX - particleX) * 0.05, 0.0, (centerZ - particleZ) * 0.05);
        }
    }
}

